<?php
if ( basename(__FILE__) == basename($_SERVER["SCRIPT_FILENAME"]) ) {
    // if not included, do nothing
    die();
}

if(!isset($before_end_body)) {
    $before_end_body='<script>';
}

$querycreate['dialercampaigns']="CREATE TABLE `dialercampaigns` (
  `id` int(10) NOT NULL auto_increment,
  `name` varchar(100) default NULL,
  `datestart` date default NULL,
  `dateend` date default NULL,
  `active` int(2) default '0',
  `concurrent` int(10) default '1',
  `destination` varchar(50) NOT NULL default '',
  `destamd` varchar(50) NOT NULL default '',
  `queue` varchar(200) default '',
  `dialprefix` varchar(20) default '',
  `starthour` time default '00:00:00',
  `endhour` time default '23:59:00',
  `dialattempts` int(10) default '1',
  `retryminutes` int(10) default '10',
  `weekdays` varchar(255) default '',
  `validdtmf` char(40) default '0,1,2,3,4,5,6,7,8,9,#,*,A,B,C,D',
  `mode` enum('preview','progressive','automatic') default 'automatic',
  `initialleg` enum('local','remote') default 'local',
  `groupbyname` int(2) default '0',
  `script` varchar(32) DEFAULT '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `nn` (`name`)
) ENGINE=InnoDB";

$querycreate['dialernumbers']="CREATE TABLE `dialernumbers` (
  `id` int(10) NOT NULL auto_increment,
  `campaign` int(10) default NULL,
  `clid` varchar(255) default NULL,
  `dest` varchar(40) default NULL,
  `lastupdate` timestamp NOT NULL default '0000-00-00 00:00:00' on update CURRENT_TIMESTAMP,
  `disposition` varchar(20) default '',
  `dialstatus` varchar(50) default '',
  `uniqueid` char(70) default NULL,
  `dialattempts` int(10) default '0',
  `priority` int(10) unsigned default '1',
  `originateid` varchar(255) default '',
  `vars` text default '',
  `agent` varchar(100) default '',
  `name` varchar(100) default '',
  `reschedule` enum('','agent','queue') DEFAULT '',
  `reschedulenote` text,
  PRIMARY KEY  (`id`),
  KEY `oriin` (`originateid`),
  KEY `uni` (`uniqueid`),
  KEY `cam` (`campaign`)
) ENGINE=InnoDB";

$querycreate['dialergroups']="CREATE TABLE `dialergroups` (
  `id` int(10) NOT NULL auto_increment,
  `groupname` varchar(100) default NULL,
  `name` varchar(100) default '',
  `number` varchar(40) default NULL,
  `clid` varchar(50) default '',
  `vars` text default '',
  PRIMARY KEY  (`id`),
  KEY `nm` (`groupname`)
) ENGINE=InnoDB";

$querycreate['dialerreports']="CREATE TABLE `dialerreports` (
  `id` int(11) NOT NULL auto_increment,
  `calldate` datetime default NULL,
  `dest` varchar(40) default NULL,
  `campaign_dest` varchar(20) default NULL,
  `campaign_name` varchar(100) default NULL,
  `uniqueid` varchar(50) default NULL,
  `agent` varchar(200) NOT NULL default '',
  `dispo` varchar(20) default '',
  `dialstatus` varchar(50) default NULL,
  `callid` varchar(90) default '',
  `dialatt` int(11) default NULL,
  `hangupcauseNum` int(6) default NULL,
  `hangupcauseText` varchar(40) default NULL,
  `originateid` varchar(255) default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `oriidattemp` (`originateid`,`dialatt`),
  KEY `uni` (`uniqueid`),
  KEY `fecha` (`calldate`),
  KEY `uniori` (`uniqueid`,`originateid`),
  KEY `ori` (`originateid`)
) ENGINE=InnoDB";

$querycreate['dialerdestinations']="CREATE TABLE `dialerdestinations` (
  `id` int(11) NOT NULL auto_increment,
  `destination` varchar(100) NOT NULL,
  `description` varchar(100) NOT NULL,
  `type` varchar(40) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB";

$querycreate['dialerdonotcall']="CREATE TABLE `dialerdonotcall` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `donotcallnumber` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `donotcallnumber` (`donotcallnumber`)
) ENGINE=InnoDB";

$querycreate['dialerdispositions']="CREATE TABLE `dialerdispositions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `disposition` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dispo` (`disposition`)
) ENGINE=InnoDB";

$querycreate['dialercampaigndispo']=" CREATE TABLE `dialercampaigndispo` (
  `campaign_id` int(10) DEFAULT NULL,
  `disposition` varchar(100) DEFAULT NULL,
  `direction` enum('inbound','outbound') DEFAULT NULL,
  KEY `campaign_id` (`campaign_id`),
  CONSTRAINT `dialercampaigndispo_ibfk_1` FOREIGN KEY (`campaign_id`) REFERENCES `dialercampaigns` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB";

$queryinsert['dialerdispositions']=array();
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Answering machine')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Appointment held')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Appointment scheduled')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Billing question')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Blind transfer')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Busy')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Call conference')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Callback am')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Callback pm')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Callback weekend')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Cancellation')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Complaint')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Complete')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Disconnected number')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Fax/data/modem')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Inactive number')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Incorrect number')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('New order')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('No answer')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Not interested')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Product question')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Refund')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Requires follow up')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Requires supervisor attention')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Sale closed')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Software error')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Tech support')";
$queryinsert['dialerdispositions'][]="INSERT INTO dialerdispositions (disposition) VALUES ('Warm transfer')";

$alldbfields   = array();
$alldbfields['dialernumbers']['reschedule']= "ALTER TABLE `dialernumbers` ADD `reschedule` enum('','agent','queue') DEFAULT '' AFTER name";
$alldbfields['dialernumbers']['reschedulenote']= "ALTER TABLE `dialernumbers` ADD `reschedulenote` text AFTER reschedule";

$set_initial_ini=0;
foreach($querycreate as $table=>$query) {
    if($db->is_connected()) {
        if(!$db->table_exists($table)) {
            $set_initial_ini=1;
            $ras = $db->consulta($query);
            if(!$ras) {
                $before_end_body.= "alertify.error('".sprintf(__("Error creating table %s!"), $table)."');\n";
            } else {
                $before_end_body.= "alertify.success('".sprintf(__("Table %s created successfully"), $table)."');\n";
                if(isset($queryinsert[$table])) {
                     foreach($queryinsert[$table] as $idx=>$insertquery) {
                         $ris = $db->consulta($insertquery);
                     }
                }
            }
        }
    }
}

foreach($alldbfields as $table => $rest) {
    if($db->table_exists($table)) {
        foreach($rest as $campo=>$query) {
            if(!$db->column_exists($table,$campo)) {
                $db->consulta($query);
                if($DEBUG==1) {
                    if (php_sapi_name() !='cli') {
                        $before_end_body.= "alertify.success('".sprintf(__('Field %s added to table %s'), $campo, $table)."');\n";
                    } else { 
                        echo sprintf(__('Field %s added to table %s'), $campo, $table)."\n";
                    }
                }
            }
        }
    }
}

// Create indexes if needed
$res = $db->consulta("DESC dialerreports");
if($res) {
    $res = $db->consulta("SHOW INDEX FROM dialerreports WHERE Key_name='oriidattemp'");
    if($db->num_rows($res)==0) {
        $db->consulta("ALTER TABLE dialerreports ADD unique oriidattemp (originateid,dialatt)");
    }
}

$res = $db->consulta("DESC dialernumbers");
if($res) {
    $res = $db->consulta("SHOW INDEX FROM dialernumbers WHERE Key_name='uni'");
    if($db->num_rows($res)==0) {
        $db->consulta("ALTER TABLE dialernumbers ADD index uni (uniqueid)");
    }
    $res = $db->consulta("SHOW INDEX FROM dialernumbers WHERE Key_name='idx_campaign_dest'");
    if($db->num_rows($res)==0) {
        $db->consulta("ALTER TABLE dialernumbers ADD INDEX idx_campaign_dest (campaign, dest)");
    }
    $res = $db->consulta("SHOW INDEX FROM dialernumbers WHERE Key_name='idx_campaign_status'");
    if($db->num_rows($res)==0) {
        $db->consulta("ALTER TABLE dialernumbers ADD INDEX idx_campaign_status (campaign, disposition, dialstatus)");
    }
}

if($set_initial_ini==1) {
    // Configure initial ini values for MySQL connection when database tables are created
    $ini_array = parse_ini_file("plugins/dialer/dialer.ini",true);

    $ini_array['database_host']=$conf['DBHOST'];
    $ini_array['database_name']=$conf['DBNAME'];
    $ini_array['database_user']=$conf['DBUSER'];
    $ini_array['database_password']=$conf['DBPASS'];

    if($config_engine=='freepbx') {
        $ini_array['asterisk_extensions_conf_file']="/etc/asterisk/extensions_custom.conf";
        $ini_array['dialer_conf_file']="/etc/asterisk/extensions_custom_dialer.conf";
    }
    if($config_engine=='issabel') {
        $ini_array['asterisk_extensions_conf_file']="/etc/asterisk/extensions_custom.conf";
        $ini_array['dialer_conf_file']="/etc/asterisk/extensions_custom_dialer.conf";
    }

    $res = array();
    foreach($ini_array as $key => $val)
    {
        if(is_array($val))
        {
            $res[] = "[$key]";
            foreach($val as $skey => $sval) $res[] = "$skey = ".(is_numeric($sval) ? $sval : '"'.$sval.'"');
        }
        else $res[] = "$key = ".(is_numeric($val) ? $val : '"'.$val.'"');
    }
    file_put_contents('plugins/dialer/dialer.ini', implode("\r\n", $res), LOCK_EX);
}

$before_end_body.="</script>\n";
