<?php

function set_destinations() {
    global $db;

    $destination = array();
    $destination_queue = array();

    if($db->table_exists('ivr')) {
        $query="SELECT displayname AS name,ivr_id AS id FROM ivr WHERE ivr_id>1";
        $res = $db->consulta($query);
        while($row = $db->fetch_assoc($res)) {
            $destination["s@ivr-".$row['id']]=_dgettext('dialer','IVR')." ".$row['name'];
        }
    }

    $query="SELECT name,id FROM ivr_details";
    $res = $db->consulta($query);
    while($row = $db->fetch_assoc($res)) {
        $destination["s@ivr-".$row['id']]=_dgettext('dialer','IVR')." ".$row['name'];
    }

    $query="SELECT announcement_id AS id,description AS name FROM announcement";
    $res = $db->consulta($query);
    while($row = $db->fetch_assoc($res)) {
        $destination["s@app-announcement-".$row['id']]=_dgettext('dialer','Announcement')." ".$row['name'];
    }

    $query="SELECT custom_dest AS id,description AS name FROM custom_destinations";
    $res = $db->consulta($query);
    while($row = $db->fetch_assoc($res)) {
        $partes = preg_split("/,/",$row['id']);
        $finaldest = $partes[1]."@".$partes[0];
        $destination[$finaldest]=_dgettext('dialer','Destination')." ".$row['name'];
    }

    $query="SELECT extension,descr FROM queues_config";
    $res = $db->consulta($query);
    while($row = $db->fetch_assoc($res)) {
        $destination[$row['extension']."@dialer-ext-queues-custom"]=_dgettext('dialer','Queue')." ".$row['descr'];
        $destination_queue[$row['extension']."@dialer-ext-queues-custom"]=$row['extension'];
    }

    return array($destination,$destination_queue);

}

?>
