<?php
header("Content-Type: text/html; charset=utf-8");
chdir("../../../../");
require_once("config.php");

$partes = preg_split("|/|",dirname($_SERVER['SCRIPT_NAME']));
$pos = array_search("menu",$partes);
if($pos!==false) {
    // It is a configuration from plugin (inside menu)
    $final = array();
    $pos = $pos - 4;  // We want to remove the 3 paths for plugins/xxxx/menu from result to set basename
    for($i=0;$i<=$pos;$i++) {
        $final[]=$partes[$i];
    }
    $path = $dir = "//".$_SERVER['HTTP_HOST'] . implode("/",$final);
} else {
    $path = $dir = "//".$_SERVER['HTTP_HOST'] . dirname($_SERVER['SCRIPT_NAME']);
}

$page_title = trans('Conversation');
// Session Variables
$context   = isset($_SESSION[MYAP]['context'])?$_SESSION[MYAP]['context']:'';
$extension = isset($_SESSION[MYAP]['extension'])?$_SESSION[MYAP]['extension']:-1;
$admin     = isset($_SESSION[MYAP]['admin'])?$_SESSION[MYAP]['admin']:0;
$allowed   = 'no';

if(isset($_SESSION[MYAP]['permit'])) {
    $permits = preg_split("/,/",$_SESSION[MYAP]['permit']);
    if($allowed=='no' && (in_array('conversation',$permits) || in_array('all',$permits))) {
       $allowed='yes';
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
<base href='<?php echo "$path/";?>'>
<?php
if(isset($page_title)) {
    echo "    <title>$page_title</title>\n";
} else {
    echo "    <title>".TITLE."</title>\n";
}

if($allowed=="no") {
    die('no perm');
}

?>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta http-equiv="imagetoolbar" content="false">
    <meta name="MSSmartTagsPreventParsing" content="true">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <link rel="stylesheet" type="text/css" href="css/jconf.css">
    <link rel="stylesheet" type="text/css" href="css/chosen.css">
    <link rel="stylesheet" type="text/css" href="css/jquery.noty.css">
    <link rel="stylesheet" type="text/css" href="css/bootstrap.min.css" media="screen">
    <link rel="stylesheet" type="text/css" href="css/bootstrap.datepicker.css">
    <link rel="stylesheet" type="text/css" href="css/dbgrid.css">
    <link rel="stylesheet" type="text/css" href="css/flags.css">
    <link rel="stylesheet" type="text/css" href="admin/css/codemirror.css">
    <link rel="stylesheet" type="text/css" href="css/coloris.min.css" media="screen">

    <script src="js/jquery-1.11.3.min.js" type="text/javascript"></script>
    <script src="js/moment-with-locales.js"></script>
    <script src="js/jquery.plugin.js"></script>
    <script src="js/jquery.noty.js"></script>
    <script src="js/chosen.jquery.js"></script>
    <script src="js/jquery.jconf.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/bootstrap-switch.min.js"></script>
    <script src="js/bootstrap-dropdown-on-hover.js"></script>
    <script src="js/bootstrap.datepicker.js"></script>
    <script src="admin/js/codemirror.js"></script>
    <script src="admin/js/mode/xml.js"></script>
    <script src="admin/js/mode/javascript.js"></script>
    <script src="admin/js/mode/htmlmixed.js"></script>
    <script src="admin/plugins/phonepro/menu/js/emojibox.js"></script>

<style>
.CodeMirror {
 background: #fcfcfc;
}

.box {
  width: 3.2rem;
  height: 3.2rem;
  _border-radius: 5px;
  _border: 1px solid #eee;
  display: flex;
  justify-content: center;
  align-items: center;
  margin: 2px;
}
.box:hover {
_  background-color:#ddd;
}
.emoji {
    font-size:2em;
    border:0;
    background-color:transparent;
    padding:0;
}

button {
border: 1px solid #ccc;
border-radius: 5px;
}

button:hover {
background-color:#ddd;
}

button:focus {outline:2px solid #ddd; _background-color:#ddd;}

#emojis {
border: 1px solid #ccc;
box-shadow: 0 0 5px #ccc;
border-radius: 10px;
padding:10px;
display:none;
max-height: 4.5em;
position:absolute;
overflow-x:hidden;
overflow-y:scroll;
background-color: #fff;
grid-template-columns: repeat(auto-fill, minmax(3rem, 1fr));
grid-gap: .3rem;
grid-auto-flow:column;
}

</style>
<?php
if(isset($extrahead)) {
    foreach($extrahead as $bloque) {
        echo "$bloque";
    }
}
?>
<script>

function debug(message) {
    if (window.console !== undefined) {
        console.log(message);
    }
}

function getCookie(name) {
    var cname = name + "=";
    var dc = document.cookie;
    if (dc.length > 0) {
        begin = dc.indexOf(cname);
        if (begin != -1) {
            begin += cname.length;
            end = dc.indexOf(";", begin);
            if (end == -1) {
                end = dc.length;
            }
            return unescape(dc.substring(begin, end));
        }
    }
    return null;
}
</script>

</head>
<body style='overflow-x: hidden;'>
<div class='container-fluid'>
<?php

$extension = preg_replace("/'/", "",  $extension );
$extension = preg_replace("/\"/", "", $extension );
$extension = preg_replace("/;/", "",  $extension );


$query = "SELECT type,number,tag FROM visual_phonebook A LEFT JOIN visual_phonebook_phones ON A.id=contact_id ";
$query.= "LEFT JOIN visual_phonebook_tags_contacts B on A.id=B.contact_id LEFT JOIN visual_phonebook_tags C ON C.id=B.tag_id ";
$query.= "WHERE A.context='$context' AND type in('whatsapp','sms') AND (owner='$extension' OR (owner<>'$extension' AND private='no'))";


$res = $db->consulta($query);
$group_map=array();
while($row=$db->fetch_assoc($res)) {
    if($row['tag']!='') {
        if(!isset($group_map[$row['type']])) {
            $group_map[$row['type']] = array();
        }

        if(!isset($group_map[$row['type']][$row['tag']])) {
            $group_map[$row['type']][$row['tag']] = array();
        }
        $group_map[$row['type']][$row['tag']][] =$row['number'];
    }
}

//echo "<pre>";
//print_r($group_map);
//echo "</pre>";

// function to write group_map as a javascript object
// $group_map is the array with the data
function write_group_map($group_map) {
    $js = "{";
    foreach($group_map as $type => $tags) {
        $js .= "'$type': {";
        foreach($tags as $tag => $numbers) {
            $js .= "'$tag': [";
            foreach($numbers as $number) {
                sort($numbers);
                $js .= "'$number',";
            }
            $js = rtrim($js,',');
            $js .= "],";
        }
        $js = rtrim($js,',');
        $js .= "},";
    }
    $js = rtrim($js,',');
    $js .= "}";
    return $js;
}
?>
<form id='conversation' action='<?php echo dirname($_SERVER['SCRIPT_NAME']); ?>/api.php'>
<input type=hidden name=did id=did>
<input type=hidden name=channel id=channel>
<input type=hidden name=participants id=participants>
<input type=hidden name=conversation id=conversationid>
<input type=hidden name=agent id=agent>
<input type=hidden name=provider id=provname>
<input type=hidden name=action id=action value='createGroupConversation'>


<div class='row'>
<div class="form-group col-sm-6">
    <label for="provider" data-trans="Select messaging provider">Select messaging provider</label><br/>
    <select data-placeholder="  " id="provider"><option value=''></option></select>
</div>
<div class="form-group col-sm-6">
    <label for="tag" data-trans="Select group to start conversation">Select group to start conversation</label><br/>
    <select data-placeholder="  " id="tag" ><option value=''></option></select>
</div>
</div>

<div class='row'>
    <div class="form-group col-sm-6">
    </div>
    <div class="form-group col-sm-6">
        <label for="contact" data-trans="Select contact to start conversation">Select contact to start conversation</label></br>
        <select data-placeholder="  " id="contact">
            <option value=''></option>
            <option value='john'>John Smith</option>
            <option value='sarah'>Sarah Johnson</option>
            <option value='mike'>Mike Williams</option>
            <option value='lisa'>Lisa Brown</option>
            <option value='david'>David Miller</option>
        </select>
    </div>
</div>

<div class='row'>
<div class='col-sm-12'>
<span id='contact_count'></span><span>&nbsp;</span>
</div>
</div>

<!--div class='row' style='margin-top:20px;'>
<div class='col-sm-12'>
<textarea id='message' name='message' class='form-control' rows='10' data-ptrans='Type your message here' placeholder='Type your message here'></textarea>
</div>
</div-->

</div>

</form>
</div>

<script>

function b64DecodeUnicode(str) {
    return decodeURIComponent(atob(str).split('').map(function(c) {
        return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
    }).join(''));
}

function b64EncodeUnicode(str) {
    return btoa(encodeURIComponent(str).replace(/%([0-9A-F]{2})/g,
        function toSolidBytes(match, p1) {
            return String.fromCharCode('0x' + p1);
    }));
}

var word = '';
gmap = <?php echo write_group_map($group_map); ?>;
var current_focus;

function load_providers() {
    parent.document.getElementById("phoneproiframe").contentWindow.getProviders().then(function(prov_list) {
        enable_conversation=0;
        isselected=true;
        for (let i = 0; i < prov_list.length; i++) {
            if(prov_list[i].allow_originate==true && prov_list[i].channel=='twilio_conversation') {
                if(parent.groupmembership.indexOf(prov_list[i].chatbroker_group)>-1 || prov_list[i].chatbroker_group == 'All Extensions') {
                    enable_conversation++;
                    if(enable_conversation==1) { isselected=true; } else { isselected=false; }
                    $('#provider').append($('<option>', { "value": prov_list[i].use_number_from+'~'+b64EncodeUnicode(prov_list[i].description)+'~'+prov_list[i].did, "text": prov_list[i].description, "selected": isselected }));
                }
            }
        }
        if(enable_conversation==0) {
            $('.btnSendBroadcast', window.parent.document).hide();
            parent.alertify.error('No messaging providers found');
        }
        $('#provider').chosen({disable_search: true, skip_no_results: true, width:'300px'});
    });
}

function load_contacts() {

    $('#contact').empty().end();
    $('#contact').append('<option value=""></option>');
    $('#contact').chosen({disable_search: false, skip_no_results: true, width:'300px'});
    $.ajax({
        url: "group_contacts_api.php/contacts",
        type: 'GET',
        dataType: 'json',
        beforeSend: function(xhr) {
            xhr.setRequestHeader("Authorization", "Basic " + btoa("admin:dk9322ksd"));
        },
        success: function(data) {
            $.each( data.data, function( key, val ) {
                $('#contact').append( $("<option>", { "selected": false, "text": val.fullname, "value": val.number}) );
            });
            $('#contact').trigger("chosen:updated");
        }
    });

}

function load_tags() {

    // load tags/categories on ajax query, do not get them twice if reloading the contacts iframe
    $.getJSON( "contacts.php?action=gettags", function( data ) {

        $('#tag').empty().end();
        $('#tag').append('<option value=""></option>');

        var category_options = $('#tag option');
        var category_values = $.map(category_options, function(option) {
            if(option.value!='') {
                return option.value;
            }
        });

        var items = [];
        $.each( data, function( key, val ) {
            if(!category_values.includes(key)) {
                $('#tag').append( $("<option>", { "selected": false, "text": val.text, "value": val.text, "data-color-option":val.color}) );
            }
        });
        $('#tag option').hide();
        //$('#tag').chosen();
        $('#tag').chosen({disable_search: true, skip_no_results: true, width:'300px'});
        $('#provider').trigger('change');

    });
}

load_providers();
load_contacts();
load_tags();

$('#tag').on('change',function() {
    var tag = $('#tag').val();
    var provider = $('#provider').val().split('~')[0];
    how_many = gmap[provider][tag].length;

    if(how_many>10) {
        text = parent.sprintf(parent.lang['Only the first 10 contacts over the %d in this group will be added to this group'],how_many);

            var htmlMarkup = '<br/><ul>';

            // Iterate over the first 10 elements of gmap[provider][tag]
            $.each(gmap[provider][tag].slice(0, 10), function(index, value) {
                htmlMarkup += '<li>' + value + '</li>';
            });

            // Close the unordered list tag
            htmlMarkup += '</ul>';

            text += htmlMarkup;

    } else {
        text = parent.sprintf(parent.lang['%d contacts will receive the message'],how_many);
    }

    $('#contact_count').html(text);
});

function set_lang_options() {
   $('#language').find('option').remove()
   var template_data = mytemplates[$('#templates').val()];
   var templangs = template_data['languages'];
   templangs.forEach((element) => {
       $('#language').append($('<option>', {
           value: element,
           text: element
       }));
   });
   $('#language').trigger("chosen:updated");
}

function set_variable_inputs() {
    $('#template_header_variables').empty();
    $('#template_body_variables').empty();
    var template_data = mytemplates[$('#templates').val()];
    var components = template_data['components'];
    if(typeof(components)=='undefined') { return; };
    components.forEach((element) => {
        var variableNumber = 1;
        element.parameters.forEach((field) => {
            var inputField = $('<input type="text" required>');
            inputField.attr('id', element.type+'_variable' + variableNumber);
            inputField.attr('name', 'variable_' + variableNumber);
            inputField.attr('class', 'form-control');
            inputField.attr('placeholder', field.name);
            $('#template_'+element.type+'_variables').append(inputField);
            variableNumber++;
        })
    })
}

$('#provider').on('change',function() {
    var provider = $('#provider').val().split('~')[0];
    var did = $('#provider').val().split('~')[2];
    var channel = 'twilio_conversation';
    $('#provname').val($("#provider option:selected").text());
    $('#did').val(did);
    $('#channel').val(channel);
    // iterate over gmap[provider] and add options to tag select
    // and print the keys of the object
    // https://stackoverflow.com/questions/684672/how-do-i-loop-through-or-enumerate-a-javascript-object
    $('#tag option').hide();
    for (var key in gmap[provider]) {
        if (gmap[provider].hasOwnProperty(key)) {
            $('#tag option').filter(function() { return $(this).text() == key; }).show();
        }
    }
    $('#tag').trigger("chosen:updated");

    $('.wtemplate').hide();
    $('.CodeMirror').show();
    $('#templates').find('option').remove()
    $('#template_body_variables').hide();
    $('#template_header_variables').hide();
});

function submit_form() {
    console.log('provider ' + $('#provider').val());
    console.log('tag ' + $('#tag').val());

    if (
      $('#provider').val() == '' ||
      (
        ($('#tag').val() == '' || $('#tag').val() == undefined) &&
        ($('#contact').val() == '' || $('#contact').val() == undefined)
      )
    ) {
        parent.alertify.error(parent.lang['Please fill all fields']);
        return;
    }

    var type = $('#provider').val().split('~')[0];
    var provider = b64DecodeUnicode($('#provider').val().split('~')[1]);
    var did = $('#provider').val().split('~')[2];
    var tag = $('#tag').val();
    var number = '';

    if(tag!='') {
        // Check if group has more than 10 elements
        if (gmap[type][tag].length > 10) {
            // Limit to the first 10 elements
            number = gmap[type][tag].slice(0, 10).join(',');
        } else {
            // Join the elements as is
            number = gmap[type][tag].join(',');
        }
    } else {
        if(number=='' && $('#contact').val()!='') {
            number = $('#contact').val();
            tag = 'Conversation '+number;
        }
    }

    // Set the values first
    $('#participants').val(number);
    $('#agent').val(parent.myextension);

    var form = $('#conversation');
    var data = form.serialize();
    var url = form.attr('action');

    // First make the AJAX request to validate and get final numbers
    $.ajax({
        type: "POST",
        url: url,
        data: data,
        success: function(data) {
            // Check if we have valid participants
            if (!data.participants || data.participants.length === 0) {
                parent.alertify.error(data.message);
                return;
            }

            final_phonenumber = data.participants.join(",");

            // Now originate the chat message with validated numbers
            parent.originate_chat_message('twilio_conversation', final_phonenumber, tag, did, provider).then(function(conversation_id) {
                console.log('after originate chat message returned, have conversation id ' + conversation_id);
                $('#conversationid').val(conversation_id);

                // Update the UI with the conversation data
                var contact_id = $('.extencontact[data-conversationid="' + conversation_id + '"]', parent.phoneproiframe.document).data('contact');
                $('#contact_' + contact_id, parent.phoneproiframe.document).data('phonenumber', final_phonenumber);
                $('#contact_' + contact_id, parent.phoneproiframe.document).attr('data-phonenumber', final_phonenumber);

                popovercontent = final_phonenumber.replace(/,/g, '<br>');
                if (popovercontent == '') {
                    popovercontent = parent.lang['None'];
                    parent.alertify.log(parent.lang.nonumbers);
                }
                $('#chimg' + conversation_id, parent.phoneproiframe.document).attr('data-content', popovercontent).attr('data-original-content', final_phonenumber).popover({content: popovercontent});

                fetch('admin/plugins/phonepro/menu/api.php?action=updateChatField&conversation='+conversation_id+'&channel=twilio_conversation&&did=' + did+'&field=extra_data&value='+data.conversation_sid).then((response) => response.json()).then((avdata) => {
                    console.log(avdata);
                })

                fetch('admin/plugins/phonepro/menu/api.php?action=updateChatField&conversation='+conversation_id+'&channel=twilio_conversation&&did=' + did+'&field=chatid&value=twilio_conversation_'+data.conversation_sid).then((response) => response.json()).then((avdata) => {
                    console.log(avdata);
                })

                fetch('admin/plugins/phonepro/menu/api.php?action=updateChatField&conversation='+conversation_id+'&channel=twilio_conversation&&did=' + did+'&field=tag&value=openchannel').then((response) => response.json()).then((avdata) => {
                    console.log(avdata);
                })



            });
        },
        error: function(xhr, status, error) {
            parent.alertify.error(parent.lang['Failed to validate phone numbers: '] + error);
        }
    });

    parent.$('#conversationcontainer').modal('hide');
}

$( document ).on( "focus", "input", function() {
  current_focus = $(this).attr('id');
})

$('.vari').on('click',function(ev) {
    ev.preventDefault();
    var text_to_insert = $(ev.currentTarget).attr('data-variable');
    if($('.CodeMirror').is(':visible')) {
        setTextToCurrentPos(myCodeMirror,text_to_insert);
    } else {
        $('#'+current_focus).val(text_to_insert);
    }
});

$('[data-trans]').each(function() {
    if(typeof(parent.lang[$(this).data('trans')])!='undefined') {
        newtext = parent.lang[$(this).data('trans')];
    } else {
        newtext = $(this).data('trans');
    }
    $(this).text(newtext);
});

$('[data-ptrans]').each(function() {
    if(typeof(parent.lang[$(this).data('ptrans')])!='undefined') {
        newtext = parent.lang[$(this).data('ptrans')];
    } else {
        newtext = $(this).data('ptrans');
    }
    $(this).attr('placeholder',newtext);
});


</script>

</body>
</html>
