<?php
$langfile = "lang/".secureFilePath(LANGUAGE).".php";
if(is_readable($langfile)) {
    require_once($langfile);
}

function jslang() {
    global $lang;
    echo "lang = {}\n";
    foreach($lang as $key=>$val) {
        echo "lang['$key']='$val';\n";
    }
}

function secureFilePath($str) {
    $str = str_replace('/', '_', $str);
    $str = str_replace('\\', '_', $str);
    $str = str_replace(DIRECTORY_SEPARATOR, '_', $str); // In case it does not equal the standard values
    return $str;
}

$dotFlatten = static function(array $item, $context = '') use (&$dotFlatten){
    $retval = [];
    foreach($item as $key => $value){
        $key = str_replace('$',"_",$key);
        $key = str_replace(':',"_",$key);
        if (\is_array($value) === true){
            foreach($dotFlatten($value, "$context$key.") as $iKey => $iValue){
                $retval[$iKey] = $iValue;
            }
        } else {
            $retval["$context$key"] = $value;
        }
    }
    return $retval;
};

function hook_debug($text) {
    global $DEBUG;
    $date = date('Y-m-d H:i:s');
    $formatted_date = sprintf('%-22s', $date);
    if($DEBUG==1) {
        file_put_contents("/tmp/chatbroker_webhook_debug.log","$formatted_date $text\n",FILE_APPEND);
    }
}
