var current_cm;
var pepemoji={};
var descmoji={};

var this_js_script = $('script[src*=emojibox]');
var path = this_js_script.attr('data-path');
if(path===undefined) {
    path='admin/plugins/phonepro/webrtcphone';
}

function fetchJsonFromApi(apiUrl) {
  return new Promise((resolve, reject) => {
    fetch(apiUrl)
      .then(response => response.json())
      .then(data => {
        resolve(data);
      })
      .catch(err => {
        console.log(err);
        reject(err);
      })
  });
};

fetchJsonFromApi(path+'/emojis.json').then((data) => {
  emojis = data.emojis;

  var mylang = getCookie('lang');
  if(mylang!==null) {
     keyw = 'keywords_'+mylang.split("_")[0];
  } else {
     keyw = 'keywords';
  }
  if(data.emojis[0][keyw]===undefined) {
     keyw = 'keywords';
  }

  for (var i = 0; i < data.emojis.length; i++) {
    pepemoji[data.emojis[i].shortcode]=data.emojis[i]['data-clipboard-text'];
    descmoji[data.emojis[i][keyw]+' '+data.emojis[i].title.toLowerCase()]=data.emojis[i].shortcode;
  }
});

function trapFocus(element,cm) {
  $(element).first('button').focus();
  var focusableEls = element.querySelectorAll('a[href]:not([disabled]), button:not([disabled]), textarea:not([disabled]), input[type="text"]:not([disabled]), input[type="radio"]:not([disabled]), input[type="checkbox"]:not([disabled]), select:not([disabled])');
  var focusable = [...focusableEls];
  focusable[0].focus();

  $(element).off('keypress');
  $(element).off('keydown');

  $(element).on('keypress', function(e) {
    if(e.keyCode>=48 && e.keyCode<=122) {
      e.preventDefault();
      cm.state.word += String.fromCharCode(e.keyCode);
      setTextToCurrentPos(cm,String.fromCharCode(e.keyCode));
      filter_emojis(cm.state.word,cm);
    }
  })

  $(element).on('keydown', function(e) {
    var isRightPressed = (e.key === 'ArrowRight' || e.keyCode === 39);
    var isLeftPressed = (e.key === 'ArrowLeft' || e.keyCode === 37);

    const index = focusable.indexOf(document.activeElement);
    if(e.keyCode==9 || e.keyCode==13) {
      e.preventDefault();
      clipboard = $(document.activeElement).attr('data-clipboard-text');
      var doc = cm.getDoc();
      var cursor = doc.getCursor();
      var line   = doc.getLine(cursor.line);
      var colonPos = line.lastIndexOf(':',cursor.ch);
      var message = cm.getValue();
      var searchRegExp = new RegExp(cm.state.word, 'g');
      var newmessage = message.replace(searchRegExp,clipboard);
      doc.setValue(newmessage);
      $('#emojis').fadeOut();
      cm.focus();
      cm.setCursor({line:cursor.line, ch:colonPos+2});
    } else if(e.keyCode==27) {
      e.preventDefault();
      $('#emojis').fadeOut();
      cm.focus();
    } else if(e.keyCode==8) {
      e.preventDefault();
      cm.state.word = cm.state.word.slice(0, -1);
      filter_emojis(cm.state.word,cm);
      var doc = cm.getDoc();
      var cursor = doc.getCursor();
      var message = doc.getLine(cursor.line);
      var newmessage = message.substring(0,cursor.ch-1) + message.substring(cursor.ch);
      var lines = [];
      for(a=0;a<doc.size;a++) {
        lines.push(doc.getLine(a));
      }
      lines[cursor.line]=newmessage;
      var pos = {
        line: cursor.line,
        ch: cursor.ch
      }
      doc.setValue(lines.join("\n"));
      cm.setCursor({line:cursor.line, ch:cursor.ch-1});
      if(cm.state.word=='') {
        console.log("emojis hide on no word");
        $('#emojis').fadeOut();
        var doc = cm.getDoc();
        var cursor = doc.getCursor();
        var line   = doc.getLine(cursor.line);
        cm.focus();
        cm.setCursor({line:cursor.line, ch:cursor.ch});
      }
    }

    if (!isRightPressed && !isLeftPressed) {
      return;
    }

    if ( isLeftPressed ) {
      e.preventDefault();
      nextIndex = index > 0? index-1: 0;
      focusable[nextIndex].focus();
    } else {
      e.preventDefault();
      nextIndex = index +1 < focusable.length? index+1: index;
      focusable[nextIndex].focus();
    }
  });
}

$(window).on('resize',function(ev) {
  $('#emojis').fadeOut();
});

$(document).on('click','.boxemj',function(ev) {
  clipboard = ($(ev.target).find('.emoji').attr('data-clipboard-text')===undefined)?$(ev.target).attr('data-clipboard-text'):$(ev.target).find('.emoji').attr('data-clipboard-text');
  cm           = current_cm;
  var doc      = cm.getDoc();
  var cursor   = doc.getCursor();
  var line     = doc.getLine(cursor.line);
  var colonPos = line.lastIndexOf(':',cursor.ch);
  var message  = cm.getValue();
  var searchRegExp = new RegExp(cm.state.word, 'g');
  var newmessage = message.replace(searchRegExp,clipboard);
  doc.setValue(newmessage);
  $('#emojis').fadeOut();
  cm.focus();
  cm.setCursor({line:cursor.line, ch:colonPos+2});
});

document.addEventListener('DOMContentLoaded', (event) => {
  $('body').append('<div id="emojis"></div>');

  $('#emojis').on('focusout',function() {  
    setTimeout(function() {
      var dummyEl = document.getElementById('emojis');
      var isFocused = (document.activeElement === dummyEl);
      if(!isFocused) {
        if($(document.activeElement).hasClass('emoji')===false) {
          $('#emojis').fadeOut();
        }
      }
    },1000);
  });

});

function startEmoji(cm) {
  // When : is typed in CodeMirror
console.log('start emjoi');
  if(typeof(cm.state.startEmoji=='undefined')) {
    cm.state.startEmoji = true;
  } else {
    cm.state.startEmoji ^= true;
  }
  cm.state.word = ':';
  filter_emojis('',cm);

  var doc = cm.getDoc();
  var cursor = doc.getCursor();
  var line = doc.getLine(cursor.line);
  var pos = {
    line: cursor.line,
    ch: cursor.ch
  }
  doc.replaceRange(':', pos);
  return CodeMirror.Pass;
}

function setTextToCurrentPos(cm,txt) {
  // caled in trapFocus
  var doc    = cm.getDoc();
  var cursor = doc.getCursor();
  var line   = doc.getLine(cursor.line);
  var pos = {
    line: cursor.line,
    ch: cursor.ch
  }
  doc.replaceRange(txt, pos);
}

function filter_emojis(word,cm) {
  current_cm = cm;
  fontSize = getComputedStyle(cm.getWrapperElement()).getPropertyValue('font-size');

  if(word.substring(0,1)==':' && word.substring(word.length-1,word.length)==':') {
    if(pepemoji[word.toLowerCase()]!==undefined && word.length>1) {

      clipboard = pepemoji[word.toLowerCase()];
      var doc = cm.getDoc();
      var cursor = doc.getCursor();
      var line   = doc.getLine(cursor.line);
      var colonPos = line.lastIndexOf(':',cursor.ch);
      var message = cm.getValue();
      var searchRegExp = new RegExp(cm.state.word, 'g');
      var newmessage = message.replace(searchRegExp,clipboard);
      doc.setValue(newmessage);
      $('#emojis').fadeOut();
      cm.focus();
      cm.setCursor({line:cursor.line, ch:colonPos+2});
      return;
    }
  }

  // buscar en pepemoji todos los que tengan key que empiecen por word
  // y si hay alguno, mostrar un popup con los emojis
  found_emojis = [];
  for (var key in pepemoji) {
    if (pepemoji.hasOwnProperty(key)) {
      if(key.startsWith(word.toLowerCase())) {
        found_emojis.push(key);
      }
    }
  }

  for (var key in descmoji) {
    if (descmoji.hasOwnProperty(key)) {
      if(key.indexOf(word.toLowerCase().substring(1))>=0) {
        found_emojis.push(descmoji[key]);
      }
    }
  }

  found_emojis = found_emojis.filter(onlyUnique);

  if(found_emojis.length>0) {
    var html = '';
    for (var i = 0; i < found_emojis.length; i++) {
      html += '<div class="boxemj"><button type="button" class="emoji" data-clipboard-text="'+pepemoji[found_emojis[i]]+'">'+pepemoji[found_emojis[i]]+'</span></button></div>';
    }
    $('#emojis').html(html);
    var doc    = cm.getDoc();
    var cursor = doc.getCursor();
    var offset = $($(cm.getWrapperElement()).find('.CodeMirror-line')[cursor.line]).offset();
    var width  = $($(cm.getWrapperElement()).find('.CodeMirror-line')).width()
    if($('#sidebar').length>0) {
      sidebar_offset = $('#sidebar').css('width');
      sidebar_offset = sidebar_offset.substring(0,sidebar_offset.length-2);
    } else {
      sidebar_offset=0;
    }

    if($('#fop2navbar').length>0) {
       topnavbar_offset=$('#fop2navbar').css('height');
       topnavbar_offset = topnavbar_offset.substring(0,topnavbar_offset.length-2);
    } else {
       topnavbar_offset=0;
    }

    var left = offset.left - sidebar_offset;
    var top = offset.top + (fontSize.substring(0,fontSize.length-2)*2) - topnavbar_offset;
    $('#emojis').css('left',left);
    $('#emojis').css('top',top);
    $('#emojis').css('max-width',width-3);
    $('#emojis').css('z-index','9999');
    $('#emojis').fadeIn().css('display','grid');
    trapFocus($('#emojis')[0],cm);
  } else {
    console.log("emojis hide on no match");
    $('#emojis').html('<div class="boxemj"><a href="" class="emoji"></a></div>');
    trapFocus($('#emojis')[0],cm);
  }
}

function onlyUnique(value, index, array) {
  return array.indexOf(value) === index;
}
