<?php

function bot_debug($logfile, $message) {
    global $config;
    if(isset($config['debug']) && $config['debug']=='yes') {
        file_put_contents("/tmp/{$logfile}.log",$message."\n",FILE_APPEND);
    }
}

class BotConfig {
    public static function load($botClass, $iniFile = null) {
        // Get template defaults
        $template = $botClass::getTemplate();
        $config = [];
        
        // Set default values from template
        foreach ($template as $key => $settings) {
            if($settings['type']=='number') {
                $config[$key] = intval($settings['default']) ?? null;
            } else {
                $config[$key] = $settings['default'] ?? null;
            }
        }
        
        // Override with INI values if file exists
        if ($iniFile && is_readable($iniFile)) {
            $iniValues = parse_ini_file($iniFile, false);
            foreach ($iniValues as $key => $value) {
                if (array_key_exists($key, $template)) {
                    $config[$key] = $value;
                }
            }
        }
        
        return $config;
    }
}

if(!is_callable("__")) {
   function __($texto) {
       return $texto;
   }
}
