<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
require_once __DIR__ . '/BotInterface.php';

class DifyBot implements BotInterface {
    public static function getKey() {
        return 'dify';
    }

    public static function getName() {
        return 'Dify';
    }

    public static function getTemplate() {
        return array(
            "dify_api_key" => array( "type" => "text",   "default" => ""),
            "dify_api_url" => array( "type" => "text",   "default" => "https://api.dify.ai/v1/chat-messages"),
            "debug"        => array( "type" => "select", "default" => "no", "options"=>array("yes"=>__('Yes'),"no"=>__('No')))
        );
    }
}
 
if (!defined('BOT_REGISTRATION_MODE') || !BOT_REGISTRATION_MODE) {
    require_once __DIR__ . '/common_functions.php';
    $logfile = basename(__FILE__,'.php');

    $iniFile = isset($_REQUEST['bot']) ? getcwd()."/".$_REQUEST['bot'].".ini" : null;
    $config = BotConfig::load('DifyBot', $iniFile);

    if ($config === null) {
        header('HTTP/1.0 403 Forbidden');
        die("Configuration file missing or inaccessible");
    }

    if($config['dify_api_key']=='' || $config['dify_api_url']=='') {
        $response = "Bot is not yet configured, be sure to set up your Dify API key and API URL";
        return array("body"=>$response,"attach"=>'');
        exit;
    }

    // Get bot input DATA
    $json = file_get_contents('php://input');
    $data = json_decode($json,1);

    if(!isset($data)) {
        header('HTTP/1.0 403 Forbidden');
        die("Bad call");
    }
    bot_debug($logfile, "POST RECEIVED:\n".print_r($data,1));

    $json = file_get_contents('php://input');
    $data = json_decode($json,1);

    $conversation_id = '';

    if($data['state']!='') {
        $state = json_decode(json_decode($data['state']),1);
        $conversation_id = $state['conversation_id'];
    }

    $query = $data['body'];
    $user  = $data['from'];

    $reply = send_to_dify($config['dify_api_url'],$config['dify_api_key'], $query, $conversation_id, $user);
    echo $reply;
    exit;
}

function send_to_dify($url, $token, $query, $conversation_id, $user) {
    global $logfile;
    bot_debug($logfile,"url: $url");

    // Prepare the request data
    $data = [
        'inputs' => [],
        'query' => $query,
        'response_mode' => 'blocking',
        'conversation_id' => $conversation_id,
        'user' => $user
    ];
    
    // Initialize cURL
    $ch = curl_init();
    
    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $token,
        'Content-Type: application/json'
    ]);
    
    // Execute the request
    $response = curl_exec($ch);
    
    // Check for errors
    if (curl_errno($ch)) {
        $error_msg = curl_error($ch);
        curl_close($ch);
        throw new Exception("cURL error: " . $error_msg);
    }
    
    // Close cURL
    curl_close($ch);

    // Decode the response
    $response_data = json_decode($response, true);
   
    bot_debug($logfile, "response: $response\n");
 
    // Check if decoding was successful and required fields exist
    if (json_last_error() !== JSON_ERROR_NONE || !isset($response_data['answer']) || !isset($response_data['conversation_id'])) {
        $return = array(
            "body" => 'Digital brain is not working',
            "attach" => ''
        );
    } else {
        // Prepare the return array
        $return = array(
            "body" => $response_data['answer'],
            "attach" => '',
            "state" => json_encode(['conversation_id' => $response_data['conversation_id']])
        );
    }
    
    return json_encode($return);
}
