<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
require_once __DIR__ . '/BotInterface.php';

class GroqBot implements BotInterface {
    public static function getKey() {
        return 'groq';
    }
    
    public static function getName() {
        return 'Groq';
    }
    
    public static function getTemplate() {
        return array(
            "groq_token"        => array( "type" => "text",     "default" => ""),
            "model"             => array( "type" => "text",     "default" => "llama3-8b-8192"),
            "system_prompt"     => array( "type" => "textarea", "default" => "You are a helpful assistant"),
            "action_prompt"     => array( "type" => "textarea", "default" => "If the user is frustrated or angry, or if the user asks to connect to a real person, you will pass the conversation to a human by appending '[transfer]' to your reply. In the farewell/goodbye message you will append '[close]' to your reply."),
            "guardrails_prompt" => array( "type" => "textarea", "default" => ". Do not answer anything that is not in your system prompt context."),
            "debug"             => array( "type" => "select",   "default" => "no", "options"=>array("yes"=>__('Yes'),"no"=>__('No')))
        );
    }
}


if (!defined('BOT_REGISTRATION_MODE') || !BOT_REGISTRATION_MODE) {
    require_once __DIR__ . '/common_functions.php';

    $iniFile = isset($_REQUEST['bot']) ? getcwd()."/".$_REQUEST['bot'].".ini" : null;
    $config = BotConfig::load('GroqBot', $iniFile);
    $logfile = basename(__FILE__,'.php');

    if ($config === null) {
        header('HTTP/1.0 403 Forbidden');
        die("Configuration file missing or inaccessible");
    }

    // Get bot input DATA
    $json = file_get_contents('php://input');
    $data = json_decode($json,1);

    if(!isset($data)) {
        header('HTTP/1.0 403 Forbidden');
        die("Bad call");
    }
    bot_debug($logfile,"POST RECEIVED:\n".print_r($data,1));

    $user_prompt = $data['body'];
    $user_prompt.=$config['guardrails_prompt']; // add guardrails to question

    $chat_context = array_slice($data['chat_context'],-5);
    $chat_context[] = array("role"=>"user","content"=>$user_prompt);

    if($config['groq_token']=='') {
        $response = "Bot is not yet configured, be sure to set up your Groq API key";
    } else {
        $response = ask_groq($config['groq_token'],$config['system_prompt']." ".$config['action_prompt'],$chat_context);
    }

    $return = array("body"=>$response,"attach"=>'');
    bot_debug($logfile,"REPLY: $response");
    echo json_encode($return);
    die();
}

function ask_groq($grok_token,$system_prompt,$user_prompt) {
    global $config, $logfile;

    $url = 'https://api.groq.com/openai/v1/chat/completions';
    $sysprompt = array();
    $sysprompt[]=array("role"=>"system","content"=>$system_prompt);
    $messages = array_merge($sysprompt,$user_prompt);
    $data = array(
       "model"=> $config['model'],
       "messages" => $messages
    );
    $data_string = json_encode($data);
    bot_debug($logfile,"Groq Messages: ".print_r($messages,1));
    $headers=array('Content-Type: application/json','Content-Length: ' . strlen($data_string),"Authorization: Bearer $grok_token");
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_TIMEOUT, 120);
    curl_setopt($ch, CURLOPT_VERBOSE, true);
    curl_setopt($ch, CURLOPT_SSLVERSION, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $return = curl_exec($ch);
    curl_close($ch);
    $response = json_decode($return,1);
    bot_debug($logfile,"Groq response: ".print_r($response,1));
    return $response['choices'][0]['message']['content'];
}
