<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
error_reporting(0);
require_once __DIR__ . '/BotInterface.php';

class InteractiveBotBot implements BotInterface {
    public static function getKey() {
        return 'interactive_bot';
    }

    public static function getName() {
        return 'Interactive Bot';
    }

    public static function getTemplate() {
        return array(
            "last_action"            => array( "type" => "select", "default" => "transfer", "options" => array("transfer"=>"transfer","close"=>"close")),
            "invalid_answer_message" => array( "type" => "text",   "default" => "No entendí la respuesta."),
            "close_message"          => array( "type" => "text",   "default" => "Gracias!"),
            "transfer_message"       => array( "type" => "text",   "default" => "Gracias, lo contactaré con un asistente humano"),
            "max_interactions"       => array( "type" => "number", "default" => 50),
            "breakout_word"          => array( "type" => "text",   "default" => "menu"),
            "breakout_step"          => array( "type" => "number", "default" => 1),
            "debug"                  => array( "type" => "select", "default" => "no", "options" => array("yes"=>__('Yes'),"no"=>__('No')))
        );
    }
}

// When registering/loading bots we do not want to process anything, just define the above class
if (!defined('BOT_REGISTRATION_MODE') || !BOT_REGISTRATION_MODE) {
    require_once __DIR__ . '/common_functions.php';
    require_once("../chatbroker.class.".PHP_MAJOR_VERSION.".php");

    $logfile = basename(__FILE__,'.php');
    $iniFile = isset($_REQUEST['bot']) ? getcwd()."/".$_REQUEST['bot'].".ini" : null;
    $config = BotConfig::load('InteractiveBotBot', $iniFile);

    if ($config === null) {
        header('HTTP/1.0 403 Forbidden');
        die("Configuration file missing or inaccessible");
    }

    $json = file_get_contents('php://input');
    $data = json_decode($json,1);

    if(!isset($data)) {
        header('HTTP/1.0 403 Forbidden');
        die("Bad call");
    }

    bot_debug($logfile,"---------------------------------------\ninteractive bot start ".$_REQUEST['bot']);

    $ini = parse_ini_file($iniFile,false);
    $questions = json_decode(base64_decode($ini['steps']),true);

    $validate_command = '';
    $interaction_counter = 0;
    $answer = trim($data['body']);
    $botdata=array();

    if($data['state']=='') {

        // First interation with bot, retrieve first question (index 0 of questions array)
        $step=0;
        bot_debug($logfile,"first interaction as we have no state");
        $botdata['body']=$answer;
        $botdata['from']=$data['from'];
        $botdata['number']=$data['number'];
        $botdata['chatid']=$data['chatid'];
        bot_debug($logfile,print_r($data,1));

    } else {

        bot_debug($logfile,"its not the first interaction");
        // Not first interaction, validate answer from previous step
        // the state field will hold the string "previous_step-step"
        // to know where we came from (to validate the answer from a previous question),
        // and when we are to print the next message/question after validating

        list($prev_step,$step,$botdata,$interaction_counter, $current_wait) = get_state($data['state']);
        $botdata['body']=$answer;
        $botdata['from']=$data['from'];
        $botdata['number']=$data['number'];
        $botdata['chatid']=$data['chatid'];

        if($interaction_counter > $config['max_interactions']) {
            if (strpos($config['last_action'], 'transfer') !== false) {
                $return = array("body"=>$config['transfer_message']." [".$config['last_action']."]","attach"=>'','state'=>'');
            } else if($config['last_action']=='close') {
                $return = array("body"=>$config['close_message']." [close]","attach"=>'','state'=>'');
            }
            echo json_encode($return);
            exit;
        }

        $step      = intval($step);
        $prev_step = intval($prev_step);
        $interaction_counter = intval($interaction_counter);

        bot_debug($logfile,print_r($data,1));

        bot_debug($logfile,"current step: $step, previous step: $prev_step, counter: $interaction_counter (".$data['state'].")");

        $validate_command = validate_answer($prev_step,$answer);

        bot_debug($logfile,"validate answer ( $prev_step, $answer) returned comand: $validate_command");
    }

    if($validate_command=='[wrong]') {
        bot_debug($logfile,"wrong");
        list($msg,$state) = retrieve_question($prev_step);
        if(isset($questions[$prev_step]['incorrectmsg']) && $questions[$prev_step]['incorrectmsg']!='') {
            $return = array("body"=>array($questions[$prev_step]['incorrectmsg']),"attach"=>'','state'=>$state);
        } else {
            $return = array("body"=>array($config['invalid_answer_message'],$msg),"attach"=>'','state'=>$state);
        }
        echo json_encode($return);
        exit;
    } else if($validate_command=='[close]') {
        $return = array("body"=>$config['close_message']." [close]","attach"=>'','state'=>'');
        echo json_encode($return);
        exit;
    } else if($validate_command=='[transfer]') {
        $return = array("body"=>$config['transfer_message']." [transfer]","attach"=>'','state'=>'');
        echo json_encode($return);
        exit;
    } else if(preg_match("/\[next=(\d+)\]/", $validate_command, $matches)) {
        $step = $matches[1];
        bot_debug($logfile,"next step from menu ".$step);
    }


    // api calls, file attachs or tag calls
    $apidata = null;
    $msg_attach = array();
    $i=0;
    while(true) {
        $i++;
        if($questions[$step]['response_type']=='apicall') {
            bot_debug($logfile,"api call step $step, $i");
            list($step,$apidata) = api_call($step);
            if ($apidata !== null) {
                $botdata['apiresult'] = $apidata;
            }
        } else if($questions[$step]['response_type']=='file') {
            bot_debug($logfile,"send file step $step, $i");
            list($step,$attach) = attach_file($step);
            $msg_attach[]=$attach;
        } else if($questions[$step]['response_type']=='tag') {
            bot_debug($logfile,"tag call $step, $i");
            $step = tag_call($step);
        } else {
            bot_debug($logfile,"break loop api/file on step $i, next step $step");
            break;
        }

        if(!isset($questions[$step])) { bot_debug($logfile,"break loop as there is no step $step"); break; }

        if( $questions[$step]['response_type']!='apicall' &&
                $questions[$step]['response_type']!='tag' &&
                $questions[$step]['response_type']!='file') { bot_debug($logfile,"break loop as the next type is ".$questions[$step]['response_type']); break; }

        if($i>100) { bot_debug($logfile,"break loop as there are too many attachs or files"); break; }
    }

    // check route step based on user message
    $step_type='';
    $i=0;
    do {
        $step = follow_route($step,$data['body'],$data['business_hours'],$data['number'],$data['chatid'],$data['from']);
        $step_type = $questions[$step]['response_type'];
        bot_debug($logfile,"return from route, goto step $step, is type $step_type");
        $i++;
    } while($step_type=='route' && $i<90);

    bot_debug($logfile,"final step after route $step");

    // api calls, file attachs or tag calls
    $apidata = null;
    $msg_attach = array();
    $i=0;
    while(true) {
        $i++;
        if($questions[$step]['response_type']=='apicall') {
            bot_debug($logfile,"api call step $step, $i");
            list($step,$apidata) = api_call($step);
            if ($apidata !== null) {
                $botdata['apiresult'] = $apidata;
            }
        } else if($questions[$step]['response_type']=='file') {
            bot_debug($logfile,"send file step $step, $i");
            list($step,$attach) = attach_file($step);
            $msg_attach[]=$attach;
        } else if($questions[$step]['response_type']=='tag') {
            bot_debug($logfile,"tag call $step, $i");
            $step = tag_call($step);
        } else {
            bot_debug($logfile,"break loop api/file on step $i, next step $step");
            break;
        }

        if(!isset($questions[$step])) { bot_debug($logfile,"break loop as there is no step $step"); break; }

        if( $questions[$step]['response_type']!='apicall' &&
                $questions[$step]['response_type']!='tag' &&
                $questions[$step]['response_type']!='file') { bot_debug($logfile,"break loop as the next type is ".$questions[$step]['response_type']); break; }

        if($i>100) { bot_debug($logfile,"break loop as there are too many attachs or files"); break; }
    }

    // if api result has a command, execute it
    if(isset($botdata['apiresult']['Response'])) {
        if(preg_match("/^\[/",$botdata['apiresult']['Response'])) {
            list($msg,$state) = retrieve_question($step);
            $return = array("body"=>$botdata['apiresult']['Response'],"attach"=>array(),"state"=>$state);
            echo json_encode($return);
            exit;
        }
    }

    list($msg,$state) = retrieve_question($step);

    bot_debug($logfile,"retrieve question $step returned  $msg, set state to $state, current answer ($answer)");

    // check for answer to wait step
    if($questions[$step]['response_type']=='wait') {
        if($step==$prev_step && $interaction_counter>1) {
            // inside a wait step, user wrote before waiting
            $msg = expand_variables($questions[$step]['response']);
            bot_debug($logfile,"received user message while on wait step, respond with $msg");

            // restore wait to original wait question value, so additional responses do not restart the timer, set wait to -1 to NOT update the wait timestamp and alter the wait counter
            $temp_state = json_decode($state,1);
            $temp_state['wait']=-1;
            $state = json_encode($temp_state);
        }
    }

    // Append configuration close or transfer messages if the command was received
    if($msg=='[close]')    $msg = $config['close_message']." [close]";
    if($msg=='[transfer]') $msg = $config['transfer_message']." [transfer]";

    if(count($msg_attach)>0) {
        bot_debug($logfile,"Has attachments");
        $save_msg = $msg;
        $msg=array();
        foreach($msg_attach as $data) {
            $msg[]='';
        }
        // insert last step that is not a file attach
        $msg[]=$save_msg;
        $msg_attach[]=array();
    }

    // Responds to chatbot with actual message and exists
    $return = array("body"=>$msg,"attach"=>$msg_attach,"state"=>$state);
    echo json_encode($return);
    exit;
}

function bot_array_key_first($myarray) {
    reset($myarray);
    return key($myarray);
}

function attach_file($step) {
    global $questions, $config, $data;
    if(!isset($questions[$step])) return array("[".$config['last_action']."]","end");
    if($questions[$step]['response_type']=='file') {
        $fileDetails = downloadFile($questions[$step]['body']);
        $step++;
        return array($step,$fileDetails);
    } else {
        return array($step,array());
    }
}

function tag_call($step) {
    global $questions, $config, $data;
    if(!isset($questions[$step])) return array("[".$config['last_action']."]","end");
    if($questions[$step]['response_type']=='tag') {
        $settag = expand_variables($questions[$step]['body']);
        // perform tag call, jump to next step
        $cb = new ChatBroker(array());
        $res = $cb->tagConversation($data['conversationid'],$settag);
        $step++;
    }
    return $step;
}

function get_state($state) {
    $state = json_decode($state);
    $astate = json_decode($state,1);
    $previous_step = $astate['previous_step'];
    $current_step  = $astate['current_step'];
    $interaction_counter  = $astate['interaction_counter'];
    $wait = isset($astate['wait'])?$astate['wait']:0;
    $botdata = $astate['data'];
    return array($previous_step,$current_step,$botdata,$interaction_counter,$wait);
}

function api_call($step) {
    global $questions, $config, $data, $botdata;
    if(!isset($questions[$step])) return array("[".$config['last_action']."]",null);
    if($questions[$step]['response_type']=='apicall') {
        $method  = $questions[$step]['httpmethod'];
        $url     = expand_variables($questions[$step]['url']);
        $body    = expand_variables($questions[$step]['body']);
        $headers = expand_variables($questions[$step]['headers']);
        $goto    = $step+1;
        $array_response = send_request($method, $url, $body, $headers, array());
        //bot_debug($logfile,"request response:\n".print_r($array_response,1));
        return array($goto,$array_response);
    } else {
        return array($step,null);
    }
}

function follow_route($step,$answer,$business_hours,$number,$chatid,$from) {
    global $questions, $config, $data, $botdata;

    $logfile = basename(__FILE__,'.php');

    if(!isset($questions[$step])) return 9999; // array("[".$config['last_action']."]","end");

    $goto = $step;

    if($questions[$step]['response_type']=='route') {

        if(isset($questions[$step]['from']) && isset($questions[$step]['from_goto'])) {
            $textoArray = explode(',',$questions[$step]['from']);
            foreach($textoArray as $texto) {
                if (trim($texto)!='') {
                if (strpos($chatid, $texto) !== false || strpos($from, $texto) !== false || strpos($number, $texto) !== false) {
                    $goto = $questions[$step]['from_goto'];
                    bot_debug($logfile,"Follow route on from, goto ($goto)");
                    return $goto;
                }
                }
            }
        }

        if(isset($questions[$step]['afterhours'])) {
            if($questions[$step]['afterhours']!='' && $business_hours=='closed') {
                $goto = $questions[$step]['afterhours'];
                bot_debug($logfile,"Follow route out of business hours, goto ($goto)");
                return $goto;
            }
        }

        // check api responses
        if($questions[$step]['apivariable']!='' && isset($botdata['apiresult'])) {
            $apiresult = $botdata['apiresult'];
            if(isset($apiresult[$questions[$step]['apivariable']])) {
                if (stripos($apiresult[$questions[$step]['apivariable']],$questions[$step]['apivariablecontent']) !== false) {
                    $goto = $questions[$step]['apivariablegoto'];
                    bot_debug($logfile,"Goto api result $goto");
                    return $goto;
                }
            } else {
               bot_debug($logfile,'There is no '.$questions[$step]['apivariable'].' in api response');
               bot_debug($logfile,print_r($apiresult,1));
            }
        }

        $valid_answers = array();
        $goto = ($questions[$step]['nomatch']!='')?$questions[$step]['nomatch']:$step+1;
        bot_debug($logfile,"Goto if not match to $goto");
        foreach($questions[$step]['options'] as $key=>$val) {
            $valid_answers[strtolower($key)]=$val;
        }
        $found=0;
        foreach($valid_answers as $key=>$dest) {
            if(preg_match("/$key/i",$answer)) {
                 $found=1;
                 $goto = $dest;
                 break;
            }
        }
        bot_debug($logfile,"Follow route found ($found), goto ($goto)");

   }

    return $goto;
}

function retrieve_question($step) {

    global $questions, $config, $data, $botdata, $interaction_counter;

    $interaction_counter++;

    $attach = array();

    if(!isset($questions[$step])) return array("[".$config['last_action']."]","end");

    $question_body = expand_variables($questions[$step]['body']);

    $wait = 0;
    if($questions[$step]['response_type']=='transfer') {
       if($questions[$step]['options']!='') {
           $question_body.="[transfer^".$questions[$step]['options']."]";
       } else {
           $question_body.="[transfer]";
       }
    } else if($questions[$step]['response_type']=='wait') {
        $wait = intval($questions[$step]['wait']);
    } else if($questions[$step]['response_type']=='close') {
        $question_body.="[close]";
    } else if($questions[$step]['response_type']=='close^nocsat') {
        $question_body.="[close^nocsat]";
    } else if($questions[$step]['response_type']=='menu') {
        if(strlen(bot_array_key_first($questions[$step]['options']))>1 && strpos($data['chatid'], "meta_") === 0) {
            // convert menu to whatsapp interactive buttons
            // menu option is not a single character/digit, asume interactive message (up to three buttons only)

            if(count($questions[$step]['options'])<4) {
                $buttons = array();
                $i=0;
                foreach($questions[$step]['options'] as $key=>$goto) {
                    if($i>2) break;
                    $buttons[] = array("type"=>"reply","reply"=>array("id"=>"id".$i,"title"=>$key));
                    $i++;
                }

                if($i>0) {
                    $body = array(
                        "type"   =>"button",
                        "body"   => array( "text" => $questions[$step]['body'] ),
                        "action" => array(
                          "buttons" => $buttons
                        )
                    );
                    $unicodeChar = '\u0008';
                    $null = json_decode('"'.$unicodeChar.'"');
                    $question_body=$null.json_encode($body);
                }
            } else {
                if(strpos($data['chatid'], "meta_whatsapp") === 0) {
                    // interactive list type
                    $items = array();
                    $i=0;
                    foreach($questions[$step]['options'] as $key=>$goto) {
                        $items[]=array("id"=>$i,"title"=>$key);
                        $i++;
                    }
                    $body = array(
                        "type" => "list",
                        "body" => array(
                            "text" => $questions[$step]['body']
                            ),
                        "action" => array(
                            "button" => "Options",
                            "sections" => array(
                                array(
                                    "title" => "Section",
                                    "rows" => $items,
                                )
                            )
                        )
                    );
                    $unicodeChar = '\u0008';
                    $null = json_decode('"'.$unicodeChar.'"');
                    $question_body=$null.json_encode($body);
                }
            }
        } else if(strlen(bot_array_key_first($questions[$step]['options']))>1 && (strpos($data['chatid'], "telegram_") === 0 || strpos($data['chatid'], "webchat_") === 0 || strpos($data['chatid'], "wuzapi_") === 0)) {
            if(strpos($data['chatid'], "webchat_") === 0) {
                $max=99;
            } else {
                $max=2;
            }
            $unicodeChar = '\u0008';
            $null = json_decode('"'.$unicodeChar.'"');
            $buttons = array();
            $i=0;
            foreach($questions[$step]['options'] as $key=>$goto) {
                if($i>$max) break;
                $buttons[] = array("type"=>"reply","reply"=>array("id"=>"id".$i,"title"=>$key));
                $i++;
            }

            $body = array('body'=>array("text"=>$questions[$step]['body']),'action'=>array('buttons'=>$buttons),"type"=>"button");
            $question_body=$null.json_encode($body);
        }

        $questions[$step]['next_action']='same';
    }

    // Define new state for returning
    $next = isset($questions[$step]['next_action'])?$questions[$step]['next_action']:'';
    if($next=='next') {
        $next_step = $step+1;
    } else if($next=='same') {
        $next_step = $step;
    } else {
        $next_step = intval($next);
    }

    // State construct
    $partialstate = array("previous_step"=>$step,"current_step"=>$next_step,"data"=>$botdata,"interaction_counter"=>$interaction_counter);
    if($wait>0) {
        $partialstate['wait']=$wait;
    }
    $state = json_encode($partialstate);

    return array($question_body,$state);
}

function validate_answer($n,$answer) {

    global $questions, $config, $botdata, $logfile;

    if(!isset($botdata['answers'])) {
        $botdata['answers']=array();
    }

    if(!isset($questions[$n])) {
        return "[".$config['last_action']."]";
    }

    $answer = extractBody($answer);

    // check break out menu option
    if($config['breakout_word']!='') {
        if(trim(strtolower($answer))==trim(strtolower($config['breakout_word']))) {
            bot_debug($logfile,"break out word detected, go to ".$config['breakout_step']);
            return "[next=".$config['breakout_step']."]";
        }
    }

    if($questions[$n]['response_type']=='text') {
        $botdata['answers'][''.$n]=$answer;

        if(isset($questions[$n]['validation'])) {
            if($questions[$n]['validation']!='') {
                if(!preg_match("/" . $questions[$n]['validation'] . "/",$answer)) {
                    return "[wrong]";
                }
            }
        }
        if($questions[$n]['next_action']!='next') {
            $next_step = $questions[$n]['next_action'];
            return "[next=$next_step]";
        }
    } else
    if($questions[$n]['response_type']=='range') {
        $valid_answers = $questions[$n]['options'];
        if(!in_array($answer,$valid_answers)) {
            return "[wrong]";
        } else {
            $botdata['answers'][''.$n]=$answer;
            if($questions[$n]['next_action']!='next') {
                $next_step = $questions[$n]['next_action'];
                return "[next=$next_step]";
            }
        }
    } else
    if($questions[$n]['response_type']=='menu') {
        bot_debug($logfile,"validate menu, answer given: $answer");
        $valid_answers=array();
        foreach($questions[$n]['options'] as $key=>$val) {
            $valid_answers[strtolower($key)]=$val;
        }
        $found=0;
        foreach($valid_answers as $key=>$goto) {
            if (preg_match("/\b$key\b/i", $answer)) {
                 $found=1;
                 $next_step = $goto;
                 $botdata['answers'][''.$n]=$answer;
                 break;
            }
        }
        if($found==0) {
            return "[wrong]";
        }
        return "[next=$next_step]";
    }
    return '';
}

function send_request($method, $url, $body='', $hdrs=array(), $auth=array()) {
    global $logfile;

    $headers = array();

    $options = array(
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_CONNECTTIMEOUT => 10,
            CURLOPT_TIMEOUT        => 10,
            CURLOPT_HEADER         => 0,
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0
            );

    if($body!='') {
        // Split by lines and process each parameter
        $lines = preg_split('/\r?\n/', trim($body));
        $params = array();

        foreach($lines as $line) {
            $line = trim($line);
            if($line && strpos($line, '=') !== false) {
                list($key, $value) = explode('=', $line, 2);
                $params[] = trim($key) . '=' . urlencode(trim($value));
            }
        }
        $body = implode('&', $params);
    }

    if($method=='POSTJSON') {

        $headers[] = 'Content-Type: application/json';

        if($body!='') {
            parse_str($body,$postfields);
            $payload = json_encode($postfields);
            $options[CURLOPT_POSTFIELDS] = $payload;
        } else {
            $options[CURLOPT_POSTFIELDS] = "{}";
        }
        $options[CURLOPT_POST] = 1;

    } else if($method=='POST') {

        if($body!='') {
            parse_str($body,$postfields);
            $options[CURLOPT_POSTFIELDS] = http_build_query($postfields);
            $options[CURLOPT_POST] = 1;
        }
    } else if(preg_match("/GET/",$method)) {
        if($body!='') {
            if(!preg_match("/\?/",$url)) { $url.="?"; } else { $url.="&"; }
            $url.=$body;
        }
    } else {
        // PUT, DELETE
        if($body!='') {
            parse_str($body,$postfields);
            $options[CURLOPT_POSTFIELDS] = http_build_query($postfields);
        }
        $options[CURLOPT_CUSTOMREQUEST] = $method;
    }

    bot_debug($logfile,"send request to $url method $method\n");

    if(is_array($hdrs)) {
        if(count($hdrs)>0) {
            foreach($hdrs as $passed_header) {
                $headers[]=$passed_header;
            }
        }
    }

    $options[CURLOPT_HTTPHEADER] = $headers;

    $urlParts = parse_url($url);
    $baseUrl = $urlParts['scheme'] . '://' . $urlParts['host'] . $urlParts['path'];
    parse_str($urlParts['query'], $params);
    $queryString = http_build_query($params);
    $encodedUrl = $baseUrl . '?' . $queryString;

    $options[CURLOPT_URL] = $encodedUrl;

    if(isset($auth['username'])) {
        $options[CURLOPT_USERPWD] = $auth['username'] . ":" . $auth['password'];
    }

    $curl = curl_init();
    curl_setopt_array($curl, $options);
    $resp = curl_exec($curl);

    if($resp === false) { $ret = array('CURL_ERROR'=>curl_error($curl)); curl_close($curl); return $ret; }

    $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

    curl_close($curl);

    if($method=='POSTJSON') {

        $ret = json_decode($resp,1);
        if($ret==null) {
            $ret = array('JSON_DECODE_ERROR'=>json_last_error_msg());
        }
        $ret['HTTP_CODE']=$httpcode;
        return $ret;
    } else {
        $ret = json_decode($resp,1);
        if($ret!=null) {
            // Returns array of decoded json response
            $ret['HTTP_CODE']=$httpcode;
            return $ret;
        } else {
            // Returns exact string returned from API call
            $final = strip_tags($resp);
            $response = array('HTTP_CODE'=>$httpcode,"Response"=>$final);
            return $response;
        }
    }
}

function expand_variables($body) {
    global $botdata;

    // New replacement: {{apiresult.user.name}}
    if (preg_match_all('/{{(.*?)}}/', $body, $matches)) {
        foreach ($matches[1] as $match) {
            $keys = explode('.', $match);
            $value = $botdata;
            $found = true;
            foreach ($keys as $key) {
                if (isset($value[$key])) {
                    $value = $value[$key];
                } else {
                    $found = false;
                    break;
                }
            }

            if ($found && (is_string($value) || is_numeric($value))) {
                $body = str_replace('{{' . $match . '}}', $value, $body);
            }
        }
    }

    // Legacy replacement: {variable}
    if (preg_match_all('/{(.*?)}/', $body, $matches)) {
        $dotFlatten = static function(array $item, $context = '') use (&$dotFlatten){
            $retval = [];
            foreach($item as $key => $value){
                $key = str_replace('$',"_",$key);
                $key = str_replace(':',"_", $key);
                if (is_array($value) === true){
                    $retval[$key.'_COUNT']=count($value);
                    foreach($dotFlatten($value, "$context$key.") as $iKey => $iValue){
                        $retval[$iKey] = $iValue;
                    }
                } else {
                    $retval["$context$key"] = $value;
                }
            }
            return $retval;
        };

        if(is_array($botdata)) {
            $flattened_data = $dotFlatten($botdata);
            foreach ($matches[1] as $match) {
                if (isset($flattened_data[$match])) {
                     $body = str_replace('{' . $match . '}', $flattened_data[$match], $body);
                }
            }
        }
    }

    return $body;
}

function downloadFile($url) {
    $tempFile = tempnam(sys_get_temp_dir(), 'download_');
    $fileHandler = fopen($tempFile, 'w');
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_FILE, $fileHandler);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    $success = curl_exec($ch);

    if (!$success) {
        fclose($fileHandler);
        unlink($tempFile);
        curl_close($ch);
        return array();
    }

    $pathInfo = pathinfo($url);
    $filename = $pathInfo['basename'];
    $mimeType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
    curl_close($ch);
    fclose($fileHandler);

    // Return an associative array with the path, MIME type, and filename
    return array(
        'file' => $tempFile,
        'mime' => $mimeType,
        'filename' => $filename
    );
}

function extractBody($msg) {
    $first_char = mb_substr($msg, 0, 1);
    if(mb_ord($first_char,'UTF-8')==8) {
        $msg = mb_substr($msg,1);
        $jsonObj = json_decode($msg,1);
        $msg = isset($jsonObj['body'])?$jsonObj['body']:$msg;
    }
    return $msg;
}
