<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
require_once __DIR__ . '/BotInterface.php';

class N8NBot implements BotInterface {
    public static function getKey() {
        return 'n8n';
    }

    public static function getName() {
        return 'N8N';
    }

    public static function getTemplate() {
        return array(
            "n8n_auth_user" => array( "type" => "text",   "default" => ""),
            "n8n_auth_pass" => array( "type" => "text",   "default" => ""),
            "n8n_chat_url"  => array( "type" => "text",   "default" => "https://n8n.server:5678/webhook/xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxx/chat"),
            "debug"         => array( "type" => "select", "default" => "no", "options"=>array("yes"=>__('Yes'),"no"=>__('No')))
        );
    }
}
 
if (!defined('BOT_REGISTRATION_MODE') || !BOT_REGISTRATION_MODE) {
    require_once __DIR__ . '/common_functions.php';
    $logfile = basename(__FILE__,'.php');

    $iniFile = isset($_REQUEST['bot']) ? getcwd()."/".$_REQUEST['bot'].".ini" : null;
    $config = BotConfig::load('N8NBot', $iniFile);

    if ($config === null) {
        header('HTTP/1.0 403 Forbidden');
        die("Configuration file missing or inaccessible");
    }

    if($config['n8n_chat_url']=='') {
        $response = "Bot is not yet configured, be sure to set up your N8N API key and API URL";
        return array("body"=>$response,"attach"=>'');
        exit;
    }

    // Get bot input DATA
    $json = file_get_contents('php://input');
    $data = json_decode($json,1);

    if(!isset($data)) {
        header('HTTP/1.0 403 Forbidden');
        die("Bad call");
    }
    bot_debug($logfile, "POST RECEIVED:\n".print_r($data,1));
    bot_debug($logfile, "CONFIG:\n".print_r($config,1));

    $json = file_get_contents('php://input');
    $data = json_decode($json,1);

    $conversation_id = '';

    if($data['state']!='') {
        $state = json_decode(json_decode($data['state']),1);
        $conversation_id = $state['conversation_id'];
    }

    $query  = $data['body'];
    $user   = $data['from'];
    $chatid = $data['chatid'];

    $reply = send_to_n8n($config['n8n_chat_url'], $query, $chatid, $user, $config['n8n_auth_user'], $config['n8n_auth_pass']);
    echo $reply;
    exit;
}

function send_to_n8n($url, $query, $chatid, $user, $authuser, $authpass) {

    global $logfile;
    bot_debug($logfile,"url: $url");

    // Prepare the request data
    $data = [
        'body' => $query,
        'chatid' => $chatid,
        'user' => $user
    ];
    
    // Initialize cURL
    $ch = curl_init();
    
    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $token,
        'Content-Type: application/json'
    ]);
   
    if (!empty($authuser) && !empty($authpass)) {
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, $authuser . ':' . $authpass);
    }
 
    // Execute the request
    $response = curl_exec($ch);
    
    // Check for errors
    if (curl_errno($ch)) {
        $error_msg = curl_error($ch);
        curl_close($ch);
        throw new Exception("cURL error: " . $error_msg);
    }
    
    // Close cURL
    curl_close($ch);

    // Decode the response
    $response_data = json_decode($response, true);
   
    bot_debug($logfile, "response: $response\n");
 
    // Check if decoding was successful and required fields exist
    if (json_last_error() !== JSON_ERROR_NONE || !isset($response_data['output'])) {
        $return = array(
            "body" => 'Digital brain is not working',
            "attach" => ''
        );
    } else {
        // Prepare the return array
        $return = array(
            "body" => $response_data['output'],
            "attach" => ''
//            "state" => json_encode(['conversation_id' => $response_data['conversation_id']])
        );
    }
    
    return json_encode($return);
}
