<?php
header("Access-Control-Allow-Origin: *"); // Replace "*" with specific origins if needed
header("Access-Control-Allow-Methods: GET, POST, OPTIONS"); // Specify the allowed HTTP methods
header("Access-Control-Allow-Headers: Content-Type"); // Specify the allowed request headers

require_once("../menu/chatbroker.class.".PHP_MAJOR_VERSION.".php");

$partes_dir = preg_split("/\//",dirname(__FILE__));
array_pop($partes_dir);
array_pop($partes_dir);
array_pop($partes_dir);
$final = '/'.join("/",$partes_dir);
chdir($final);
require_once("config.php");
require_once("functions.php");
require_once("dblib.php");
require_once("asmanager.php");
require_once("system.php");
require_once("dbconn.php");

if ($_SERVER["REQUEST_METHOD"] === "OPTIONS") {
    exit(); // Return early for OPTIONS requests to avoid further processing
}

$chatbroker_dir = "/var/www/html/fop2/admin/plugins/phonepro/menu";
require_once($chatbroker_dir."/chatbroker.class.".PHP_MAJOR_VERSION.".php");
$cb   = new ChatBroker(array());

$json = file_get_contents('php://input');
$data = json_decode($json,1);

if(isset($data['newchat'])) {

    $page = $data['page'];
    $autocreate = $data['autocreate'];
    $ret = $cb->get_provider_config("webchat",$data['page']);
    $tenant_context = $ret['context'];
    if($tenant_context===null) {
        $tenant_context='';
    }
    $template_config = json_decode($ret['chatbroker_template'],1);
    $valid_referer = $template_config['URL'];
    check_referer($valid_referer);

    if($tenant_context!='') {
        $tenant_context=$tenant_context."_";
    }

    $webmailDomain = "webuser_".$tenant_context.strtolower($page)."_".$data['newchat'];
    $finalDomain = $webmailDomain;

    $ret = $cb->get_pb_webuser($data['newchat'],$finalDomain);
    if(count($ret['items'])==0) {
        if($autocreate==1) {
            $userInfo = array(
                "name" => $data['name'],
                "email" => $data['email'],
                "user_agent" => $_SERVER['HTTP_USER_AGENT'],
                "remote_ip" => $_SERVER['REMOTE_ADDR']
            );

            $userid = $cb->add_pb_user($data['newchat'],$data['newchat'],$finalDomain,json_encode($userInfo));
            echo "{\"id\":\"{$data['newchat']}\",\"domain\":\"$tenant_context\",\"name\":\"{\\\"name\\\":\\\"{$data['name']}\\\"}\"}";
            exit;
        } else {
            echo "{\"id\":\"none\"}";
            exit;
        }
    } else {
        $userid     = $ret['items'][0]['id'];
        $name_data  = $ret['items'][0]['name'];

        $name  = '';
        $email = '';

        // Check if $name_data is a JSON string
        $json_decoded = json_decode($name_data, true);
        if (is_array($json_decoded)) {
            //$name  = isset($json_decoded['name'])  ? $json_decoded['name']  : $ret['items'][0]['username'];
            //$email = isset($json_decoded['email']) ? $json_decoded['email'] : '';
            $name = $name_data;
        } else {
            // Handle the ~ delimiter case
            $partes = preg_split("/~/", $name_data);
            $name  = isset($partes[0]) ? $partes[0] : $ret['items'][0]['username'];
            $email = isset($partes[1]) ? $partes[1] : '';
        }

    }
    $response = array("id"=>$data['newchat'], "domain"=>$tenant_context, "name"=>$name, "email"=>$email);
    echo json_encode($response);
    exit;

} elseif(isset($data['addcontact'])) {

    $page = $data['page'];
    $ret = $cb->get_provider_config("webchat",$data['page']);
    $tenant_context = $ret['context'];

    $template_config = json_decode($ret['chatbroker_template'],1);
    $valid_referer = $template_config['URL'];
    check_referer($valid_referer);

    if($tenant_context!='') {
        $tenant_context=$tenant_context."_";
    }
    $webmailDomain = "webuser_".$tenant_context.strtolower($page)."_".$data['id'];
    $finalDomain = $webmailDomain;

    // Collect dynamic fields
    $dynamicFields = [];
    foreach ($data as $key => $value) {
        if ($key !== 'addcontact' && $key !== 'id' && $key !== 'page') {
            $dynamicFields[$key] = $value;
        }
    }

    // Assign one field as the "from" field (e.g., email or name)
    $fromField = $dynamicFields['email'] ?? $dynamicFields['full_name'] ?? $dynamicFields['name'] ?? $data['id'];

    $userid = $cb->add_pb_user($data['id'], $data['id'], $finalDomain, json_encode($dynamicFields));
    echo json_encode(["id" => $data['id'], "domain" => $tenant_context, "from" => $fromField]);

} elseif(isset($data['newmsg'])) {

    $fromid = $data['id'];
    $body   = $data['newmsg'];
    $page   = $data['page'];

    // Collect all form fields (excluding newmsg, id, and page)
    $formFields = array();
    foreach ($data as $key => $value) {
        if (!in_array($key, ['newmsg', 'id', 'page', 'attachments'])) {
            $formFields[$key] = $value;
        }
    }
    $formFields['remote_ip']=$_SERVER['REMOTE_ADDR'];
    $formFields['user_agent']=$_SERVER['HTTP_USER_AGENT'];

    $from = $fromid;

    if (!empty($formFields['email'])) {
        $from = $formFields['email'];
    } elseif (!empty($formFields['full_name'])) {
        $from = $formFields['full_name'];
    } elseif (!empty($formFields['name'])) {
        $from = $formFields['name'];
    }

    $ret = $cb->get_provider_config("webchat",$page);
    $template_config = json_decode($ret['chatbroker_template'],1);
    $valid_referer = $template_config['URL'];
    check_referer($valid_referer);

    $extra_data = $formFields;

    // Handle file attachments if present
    $attachment_files = array();
    if (isset($data['attachments']) && is_array($data['attachments']) && count($data['attachments']) > 0) {
        $attachments_dir = '/tmp/chat_attachments/';
        if (!file_exists($attachments_dir)) {
            mkdir($attachments_dir, 0777, true);
        }

        foreach ($data['attachments'] as $attachment) {
            if (isset($attachment['data']) && isset($attachment['name'])) {
                $file_data = base64_decode($attachment['data']);
                $file_name = $attachment['name'];
                $file_path = $attachments_dir . uniqid() . '_' . $file_name;
                if (file_put_contents($file_path, $file_data)) {
                    $mimetype = isset($attachment['type']) ? $attachment['type'] : 'application/octet-stream';
                    $attachment_files[] = array(
                        'file' => $file_path,
                        'filename' => $attachment['name'],
                        'mimetype' => $mimetype
                    );
                }
            }
        }
    }

    $j_extra_data = base64_encode(json_encode($extra_data));

    $actual_path = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://localhost$_SERVER[REQUEST_URI]";
    $url = dirname($actual_path)."/../menu/hook.php?webchat=1";
    $ch = curl_init();
    $post_data="from=$from&to=$page&body=$body&fromid={$fromid}&extra={$j_extra_data}";

    if (!empty($attachment_files)) {
        $attachments_param = urlencode(implode(',', $attachment_files));
        $attachments_param = "&attach=" . urlencode(json_encode($attachment_files));
        $post_data .= "&attach={$attachments_param}";
    }
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_VERBOSE, 0);
    $server_output = curl_exec($ch);
    curl_close($ch);
    echo "{\"status\":\"ok\"}";
}

function check_referer($ref) {
    $request_referer = isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:$_SERVER['HTTP_ORIGIN'];
    if(!preg_match("/$ref/i",$request_referer)) {
        echo "{\"status\":\"forbidden\"}";
        exit;
    }
}
