<?php
// custom fields for queuelogin
//$custom_field['user']['name']['text']='name';
$custom_field['user']['allowed_profiles[]']['multiselect']='allowed_profiles';


$cust_fields = array();

$new_field = array( 
    'section'       => 'user',
    'name'          => 'allowed_profiles[]',
    'displayname'   => _dgettext('queuelogin','Allowed Profiles'),
    'type'          => 'multiselect',
    'variablename'  => 'allowed_profiles',
    'helptext'      => _dgettext('queuelogin','Select the profiles the agent will have enabled'),
    'template'      => true
);
$cust_fields[]=$new_field;


function queuelogin_update_conf() {
    // Run update_conf.php in order to populate buttons and groups if needed
    $base_plugin_path = substr(dirname(__FILE__),0,strrpos(dirname(__FILE__),"/"));
    $confini = parse_ini_file($base_plugin_path."/configonreload/configonreload.ini");
    exec($confini['reload_script']);
}

function queuelogin_set_custom_on_default_template_add() {
    global $db, $conf, $astman, $fp;
    $jscode = '';
    $selected_def_template = fop2_get_deftemplate();
    $query = "SELECT custom FROM fop2templates WHERE id='%s'";
    $res    = $db->consulta($query,array($selected_def_template));
    if($res) {
        if($db->num_rows($res)>0) {
            $mirow = $db->fetch_row($res);
            $jdata = $mirow[0];
            $data = json_decode($jdata);
            $allowprofile = array();
            if(isset($data->fields->allowed_profiles) && is_array($data->fields->allowed_profiles)) {
                $allowprofile = $data->{'fields'}->{'allowed_profiles'};
            }
            $jscode = '$("#allowed_profiles").val(["'.implode('","',$allowprofile).'"]);'."\n";
            $jscode .= '$("#allowed_profiles").trigger("chosen:updated");'."\n";
            $jscode.="console.log('$allowprofile');\n";
        }
    }
    return $jscode;
}

function queuelogin_update_users_on_template_change($templateid,$users) {
    global $db, $conf, $astman, $fp;

    $query = "SELECT custom FROM fop2templates WHERE id='%s'";

    $res    = $db->consulta($query,array($templateid));
    if($res) {
        if($db->num_rows($res)>0) {
            $mirow = $db->fetch_row($res);
            $jdata = $mirow[0];
            $data = json_decode($jdata);
            $allowprofile = $data->{'fields'}->{'allowed_profiles'};
        }

        if(!$res = $astman->connect($conf['MGRHOST'].':'.$conf['MGRPORT'], $conf['MGRUSER'] , $conf['MGRPASS'], 'off')) {
            unset($astman);
        }


        if ($astman) {
            foreach($users as $exten) {
                $sallow = implode(",",$allowprofile);
                $astman->database_put("QUEUEPROFILE/".$exten,"allowed",$sallow);
            }
        }
        queuelogin_update_conf();
    }
}

function queuelogin_populate_data($data) {

    if(count($data)==0) {
        $jscode = queuelogin_set_custom_on_default_template_add();
    } else {
        $jscode = '';
    }

    global $allowed_profiles,$selected_allowed_profiles, $db, $astman, $conf;
    $allowed_profiles = array();
    $ini_array = parse_ini_file("queuelogin.ini",true);
    foreach($ini_array as $key => $deta) {
        if(is_array($deta)) {
           $allowed_profiles[]=$key;
        }
    }

    $selected_allowed_profiles = array();

    if(isset($data['itemid'])) {

    $caller = debug_backtrace();
    if(preg_match("/fop2users/",$caller[0]['file'])) {

        $itemid = $data['itemid'];
        $query  = "SELECT exten FROM fop2users WHERE id='$itemid'";
        $res    = $db->consulta($query);
        if($res) {
            if($db->num_rows($res)>0) {
                $mirow = $db->fetch_row($res);
                $exten = $mirow[0];

                if(!$res = $astman->connect($conf['MGRHOST'].':'.$conf['MGRPORT'], $conf['MGRUSER'] , $conf['MGRPASS'], 'off')) {
                    unset($astman);
                }

                if ($astman) {
                    $sl = $astman->database_get("QUEUEPROFILE/".$exten,"allowed");
                    if($sl<>"") { 
                        $selected_allowed_profiles = explode(",",$sl);
                    }
                
 
                }
            }
        }

    } else {
        $itemid = $data['itemid'];
        $query = "SELECT custom FROM fop2templates WHERE id='$itemid'";
        $res    = $db->consulta($query,array($itemid));
        if($res) {
            if($db->num_rows($res)>0) {
                $mirow = $db->fetch_row($res);
                $jdata = $mirow[0];
                $data = json_decode($jdata);
                $selected_allowed_profiles = $data->{'fields'}->{'allowed_profiles'};
            }
        }
    }

    }

    if($jscode<>'') {
    echo "<script> \$(document).ready(function() {  $jscode });</script>";
    }
}

function queuelogin_edit_user($data) {
    global $db, $astman, $conf, $selected_allowed_profiles, $allowed_profiles;

    $allowprofile = isset($data['allowed_profiles'])?$data['allowed_profiles']:array();

    $selected_allowed_profiles=array();
    foreach($allowprofile as $kk) {
        $selected_allowed_profiles[]=$kk;
    }

    $itemid = $data['itemid'];
    $query  = "SELECT exten FROM fop2users WHERE id='$itemid'";
    $res    = $db->consulta($query);

    if($res) {
        if($db->num_rows($res)>0) {

            $mirow = $db->fetch_row($res);
            $exten = $mirow[0];

            if(!$res = $astman->connect($conf['MGRHOST'].':'.$conf['MGRPORT'], $conf['MGRUSER'] , $conf['MGRPASS'], 'off')) {
                unset($astman);
            }

            if ($astman) {
                $astman->database_put("QUEUEPROFILE/".$exten,"allowed",implode(",",$allowprofile));
            }
            queuelogin_update_conf();
            queuelogin_populate_data($data);
        }}
    return true;
}

function queuelogin_edit_template($data) {
    global $db, $astman, $conf, $selected_allowed_profiles, $allowed_profiles, $panelcontext;

    $finaldata = array();
    $templateid = $data['itemid'];
    $query = "SELECT custom FROM fop2templates WHERE id='%s'";
    $res=$db->consulta($query,array($templateid));
    if($res) {
        if($db->num_rows($res)>0) {
            $mirow = $db->fetch_row($res);
            $custom = $mirow[0];
            $finaldata = json_decode($custom,1);
        }
    }

    $allowprofile = $data['allowed_profiles'];
    $finaldata['fields']['allowed_profiles']=$allowprofile;
    $datastore = json_encode($finaldata);

    $values=array();
    $values[] = $datastore;
    $values[] = $templateid;

    $query = "UPDATE fop2templates SET custom='%s' WHERE id='%s'";
    $db->consulta($query,$values);

    if($panelcontext<>'' && $panelcontext<>'GENERAL') {
        $where = " context_id = '$panelcontext' ";
    } else {
        $where = " context_id is null or context_id='GENERAL' ";
    }

    $where .= " AND id_template='$templateid' ";

    $results = $db->select("exten","fop2UserTemplate","",$where);
    $user_extension_to_change = array();
    if(is_array($results)){
        foreach($results as $result){
            $user_extension_to_change[]=$result['exten'];
        }
    }

    queuelogin_update_users_on_template_change($templateid,$user_extension_to_change);

    queuelogin_populate_data($data);

}

function queuelogin_add_template($data) {
    global $db,$astman,$conf,$allowed_profiles,$selected_allowed_profiles;
    $allowprofile = $data['allowed_profiles'];
    $data['itemid']=$data['id']; 

    queuelogin_edit_template($data);

    return true;
}

function queuelogin_add_user($data) {
    global $db,$astman,$conf,$allowed_profiles,$selected_allowed_profiles;

    $allowprofile = $data['allowed_profiles'];

    if(!is_array($allowprofile)) { $allowprofile=array(); }

    if(!$res = $astman->connect($conf['MGRHOST'].':'.$conf['MGRPORT'], $conf['MGRUSER'] , $conf['MGRPASS'], 'off')) {
        unset($astman);
    }
    if ($astman) {
        $astman->database_put("QUEUEPROFILE/".$data['userid'],"allowed",implode(",",$allowprofile));
    }

    queuelogin_update_conf();
    queuelogin_populate_data($data);
    return true;
}

function queuelogin_del_user($data) {
    global $db, $astman, $conf;

    $id = intval($data['exten']);

    if(!$res = $astman->connect($conf['MGRHOST'].':'.$conf['MGRPORT'], $conf['MGRUSER'] , $conf['MGRPASS'], 'off')) {
        unset($astman);
    }

    if ($astman) {
        $astman->database_del("QUEUEPROFILE/".$id,"allowed");
    }

    queuelogin_update_conf();
    return true;
}

function queuelogin_profiles_dashboard_widget($name,$link,$icon) {
    $count = 0;
    $ini_array = parse_ini_file("plugins/queuelogin/queuelogin.ini",true);
    foreach($ini_array as $key => $data) {
        if(is_array($data)) {
            $count++;
        }
    }
    draw_dashboard_widget(_dgettext('queuelogin',$name),$link,$icon,$count);
}
