<?php
chdir("../../../");
require_once("config.php");
require_once("functions.php");
require_once("system.php");
require_once("dblib.php");
require_once("asmanager.php");
require_once("dbconn.php");
require_once("secure/secure-functions.php");
require_once("secure/secure.php");

_bindtextdomain('queuelogin', realpath('./').'/plugins/queuelogin/i18n/');
$encoding = 'UTF-8';
_bind_textdomain_codeset('queuelogin', $encoding);

// Leo el ini
$ini_array = parse_ini_file("plugins/queuelogin/queuelogin.ini",true);

set_queue_names();
reset_queues_array();

$before_end_body = final_javascript_code();

$showlist=1;
$showedit=0;
if(isset($_REQUEST['profile'])) {
    // edit, delete or add new profile
    if(isset($_REQUEST['action'])) {
        if($_REQUEST['action']=='delete') {
            delete_profile($_REQUEST['profile']);
            reload_asterisk();
            sleep(2);
            $showlist=1; $showedit=0;
        } else if ($_REQUEST['action']=='edit') {
            $showedit=1; $showlist=0;
        } else if ($_REQUEST['action']=='insert') {
            $showedit=1; $showlist=0;
        }
    } 
}
else if(isset($_REQUEST['currency'])) {
    // save profile to disk
    save_data($_REQUEST);
    $showlist=1; $showedit=0;
    reload_asterisk();
    sleep(2);
    set_queue_names();
} 

include("headerbs.php");

echo "<div class='wrap'>\n";
include("menu.php");
echo "<div class='row'>\n<div class=\"content\">\n";

if($showlist==1) {
   show_profile_list();
} else {
   edit_profile($_REQUEST['profile']);
}

// funcion que setea nombres de cola sacados de freepbx
function set_queue_names() {
    global $queuename,$queueid;
    // Guardo en queuename un array asociativo extension = nombre de cola
    $queuename=array();
    $queueid=array();
    $queue_conf = queues_check_extensions_freepbx();
    foreach($queue_conf as $idx => $arrdata) {
        $name=''; $exten='';
        foreach($arrdata as $key=>$val) {
            if($key=='name') { $name = $val; }
            if($key=='exten') { $exten = $val; }
        }
        $queuename[$exten]=$name;
        $queueid[$name]=$exten;
    }
}


// function que imprime que colas tiene un perfil
function print_queue_penalties($elements) {
    global $queuename;
    $return = '';
        foreach($elements as $valor) {
            $partes = preg_split("/,/",$valor);
            $cola = $partes[0];
            $pty = $partes[1];
            if(!isset($queuename[$cola])) { $queuename[$cola]=''; }
            if(trim($queuename[$cola])<>'') {
                $return .= sprintf(_dgettext('queuelogin','Queue %s with penalty %s'),$queuename[$cola],$pty)."<br/>";
            }
        } 
    return $return;
}

// funcion que imprime codigo javascript para agregar cada cola de un perfil en el carro
function print_queue_penalties_js($elements) {
    global $queuename;
    $returno = "";
    if(is_array($elements)) {
        foreach($elements as $valor) {
            $partes = preg_split("/,/",$valor);
            $cola = $partes[0];
            $pty = $partes[1];
            $returno .= "simpleCart.add({ name: '".$queuename[$cola]."', penalty: ".$pty." });\n"; 
        } 
    } 
    return $returno;
}

function reset_queues_array() {
    global $queues,$ini_array,$configured_profiles;
    $configured_profiles = array();
    $queues = array();
    foreach($ini_array as $key => $data) {
        if(is_array($data)) {
            $configured_profiles[]=$key;
            if($data['profile']<>'') {
                $queues[$key]=explode("|",$data['profile']);
            }
        }
    }
}


?>

<style>
    .shelfitem { float: left; padding:5px; width: 150px;}
    .item-name { float: left; padding:13px; width: 200px;}
    .item-penalty { float: left; padding:13px; width: 150px; }
    .item-remove { float: left; padding:0px; }
    .itemRow { clear:both; }
    .simpleCart_quantity { display: none; }
    .simpleCart_total { display: none; }
    .simpleCart_items { margin-top: 20px; }
    h2, h3 { margin-top: 0px; }
    .headerrow { display: flex; background-color: #ed2;}
</style>

<?php

function delete_profile($profile) {
    global $ini_array, $astman, $conf;
    unset($ini_array[$profile]);

    $res = array();
    foreach($ini_array as $key => $val)
    {
        if(is_array($val))
        {
            $res[] = "[$key]";
            foreach($val as $skey => $sval) $res[] = "$skey = ".(is_numeric($sval) ? $sval : '"'.$sval.'"');
        }
        else $res[] = "$key = ".(is_numeric($val) ? $val : '"'.$val.'"');
    }
    file_put_contents('plugins/queuelogin/queuelogin.ini', implode("\r\n", $res), LOCK_EX);

    if(!$res = $astman->connect($conf['MGRHOST'].':'.$conf['MGRPORT'], $conf['MGRUSER'] , $conf['MGRPASS'], 'off')) {
        unset($astman);
    }

    if ($astman) {
        $astman->database_del("dialprefix",$profile);
    }


    exec("/var/lib/asteirsk/bin/retrieve_conf");
}

function save_data($post) {

    global $queueid,$ini_array,$queues,$astman,$conf;
    $queue = array();

    foreach($post as $key=>$val) {
        if(preg_match("/item_name_([\d]*)/",$key,$matches)) {
            $queue[$matches[1]]=$val;
        }
        if(preg_match("/item_options_([\d]*)/",$key,$matches)) {
            $val = preg_replace("/penalty: /","",$val);
            $penalty[$matches[1]]=$val;
        }
        if(preg_match("/profilename/",$key,$matches)) {
            $profile = $val;
        }
    }

    if(count($queue)>0) {
        $final = array();
        foreach($queue as $id=>$name) {
            //echo "Guardando profile $profile, Cola $name (".$queueid[$name].") con penalty ".$penalty[$id]."<br>";
            $final[]=$queueid[$name].",".$penalty[$id];
        }
        $finalstr = implode("|",$final);
        $ini_array[$profile]['profile']=$finalstr;
    } else {
        $ini_array[$profile]['profile']="$profile,0";
    }

    //$ini_array[$profile]['prefix']=$post['prefix'];
    $ini_array[$profile]['agent_queue_prefix']=$post['queueprefix'];
    $ini_array[$profile]['popup_ringing_url']=base64_encode($post['popupurl_ringing']);
    $ini_array[$profile]['popup_connect_url']=base64_encode($post['popupurl_connect']);

    $res = array();
    foreach($ini_array as $key => $val)
    {
        if(is_array($val))
        {
            $res[] = "[$key]";
            foreach($val as $skey => $sval) $res[] = "$skey = ".(is_numeric($sval) ? $sval : '"'.$sval.'"');
        }
        else $res[] = "$key = ".(is_numeric($val) ? $val : '"'.$val.'"');
    }
    file_put_contents('plugins/queuelogin/queuelogin.ini', implode("\r\n", $res), LOCK_EX);

    if(!$res = $astman->connect($conf['MGRHOST'].':'.$conf['MGRPORT'], $conf['MGRUSER'] , $conf['MGRPASS'], 'off')) {
        unset($astman);
    }

    if ($astman) {
        $astman->database_put("dialprefix",$profile,$post['prefix']);
    }

    // actualizo el array queues
    foreach($ini_array as $key => $data) {
        if(is_array($data)) {
            if($data['profile']<>'') {
               $queues[$key]=explode("|",$data['profile']);
            }
        }
    }

    exec("/var/lib/asterisk/bin/retrieve_conf");
}


function show_profile_list() {
    global $configured_profiles, $queues, $ini_array;
    reset_queues_array();
    echo "<br><div class='container-fluid'>";
    foreach($configured_profiles as $profile) {

        $elemid = "delete_$profile";
        $elemid = preg_replace('/[^A-Za-z0-9]/','',$elemid);

        echo "<div class='well col-xs-12'>";
        echo "<div class='row'>";
        echo "<div class='col-xs-10'>";
        echo "<h2>"._dgettext('queuelogin','Profile').": $profile</h2>";
        echo print_queue_penalties($queues[$profile]);
        if($ini_array[$profile]['prefix']<>'') {
            echo "<br/>"._dgettext('queuelogin','Dial Prefix').": ".$ini_array[$profile]['prefix'];
        }
        if($ini_array[$profile]['agent_queue_prefix']<>'') {
            echo "<br/>"._dgettext('queuelogin','Agent Queue Prefix').": ".$ini_array[$profile]['agent_queue_prefix']."<br>";
        }
        if($ini_array[$profile]['popup_ringing_url']<>'') {
            echo "<br/>"._dgettext('queuelogin','URL Popup Ringing:')." ".base64_decode($ini_array[$profile]['popup_ringing_url'])."<br>";
        }
        if($ini_array[$profile]['popup_connect_url']<>'') {
            echo "<br/>"._dgettext('queuelogin','URL Popup Connect:')." ".base64_decode($ini_array[$profile]['popup_connect_url'])."<br>";
        }
        echo "</div>";
        echo "<div class='col-xs-2'><br/><br/><br/>";
        echo "<div class='row'>";
        echo "<div class='col-xs-6'><form method='get' id='$elemid'><input type=hidden name=profile value='$profile'><input type=hidden name=action value='delete'><button type='submit' class='btn btn-warning' onclick='confirmDelete(\"".$elemid."\"); return false;'>".__('Delete')."</button></form>&nbsp;</div>";
        echo "<div class='col-xs-6'><form method='get'><input type=hidden name=profile value='$profile'><input type=hidden name=action value='edit'><button type='submit' class='btn btn-success'>".__('Edit')."</button></form></div>";
        echo "</div>";
        echo "</div>";
        echo "</div>"; 
        echo "</div>";
    }
    echo "<button type='submit' class='btn btn-primary' onclick='agregar();'>".sprintf(__('Add %s'),_dgettext('queuelogin','Profile'))."</button>";
    echo "<input type=text name='prefijo' id='prefijo' class='form-control' style='display:none;'>";
    echo "<input type=text name='prefijoqueue' id='prefijoqueue' class='form-control' style='display:none;'>";
    echo "<input type=text name='popupurl_ringing' id='popupurl_ringing' class='form-control' style='display:none;'>";
    echo "<input type=text name='popupurl_connect' id='popupurl_connect' class='form-control' style='display:none;'>";
    echo "</div>";
}

function edit_profile($profile) {

    global $queuename, $queues, $ini_array;

    reset_queues_array();

    $titulo = _dgettext('queuelogin','Edit profile');
    $prefixval = isset($ini_array[$profile]['prefix'])?$ini_array[$profile]['prefix']:'';
    $prefixqueueval = isset($ini_array[$profile]['agent_queue_prefix'])?$ini_array[$profile]['agent_queue_prefix']:'';
    $popupurl_ringing = isset($ini_array[$profile]['popup_ringing_url'])?base64_decode($ini_array[$profile]['popup_ringing_url']):'';
    $popupurl_connect = isset($ini_array[$profile]['popup_connect_url'])?base64_decode($ini_array[$profile]['popup_connect_url']):'';

    if(isset($_REQUEST['action'])) {
        if($_REQUEST['action']=='insert') {
            $titulo = _dgettext('queuelogin','Add profile');
        } else {
            $titulo = _dgettext('queuelogin','Edit profile');
        }
    }

    echo "<br><div class='container-fluid'>\n";
    echo "<h2>$titulo $profile</h2>\n";

    echo "<div class='row' style='padding: 0 15px 0 15px'>\n";
    echo "<div class='col-xs-12 well'>\n";

/*
    echo "<div class='row' style='margin-bottom:10px; padding: 0 15px 0 15px;'>\n";
    echo "<div class='col-xs-6 col-sm-3'>"._dgettext('queuelogin','Dial Prefix').":</div>\n";
    echo "<div class='col-xs-6 col-sm-6'><input type=text name='prefijo' id='prefijo' class='form-control' value='$prefixval'></div>\n";
    echo "</div>\n";
*/

    echo "<div class='row' style='margin-bottom:10px; padding: 0 15px 0 15px;'>\n";
    echo "<div class='col-xs-6 col-sm-3'>"._dgettext('queuelogin','Agent Queue Prefix').":</div>\n";
    echo "<div class='col-xs-6 col-sm-6'><input type=text name='prefijoqueue' id='prefijoqueue' class='form-control' value='$prefixqueueval'></div>\n";
    echo "</div>\n";
    echo "<div class='row' style='margin-bottom:10px; padding: 0 15px 0 15px;'>\n";
    echo "<div class='col-xs-6 col-sm-3'>"._dgettext('queuelogin','URL Popup Ringing').":</div>\n";
    echo "<div class='col-xs-6 col-sm-6'><input type=text name='popupurl_ringing' id='popupurl_ringing' class='form-control' value='$popupurl_ringing'></div>\n";
    echo "</div>\n";

    echo "<div class='row' style='margin-bottom:10px; padding: 0 15px 0 15px;'>\n";
    echo "<div class='col-xs-6 col-sm-3'>"._dgettext('queuelogin','URL Popup Connect').":</div>\n";
    echo "<div class='col-xs-6 col-sm-6'><input type=text name='popupurl_connect' id='popupurl_connect' class='form-control' value='$popupurl_connect'></div>\n";
    echo "</div>\n";


    echo "</div>\n";
    echo "</div>\n";

    echo "<div class='row' style='padding: 0 15px 0 15px;'>\n";
    echo "<div class='col-xs-5 well'>\n";
    echo "<h3>"._dgettext('queuelogin','Available Queues')."</h3>\n";
    //echo "<hr>\n";
    echo "<div style='margin-top:30px;'>\n";
    foreach($queuename as $exten=>$queue) {
        echo "<div class='simpleCart_shelfItem row'>\n";
        echo "<div class='item_name col-xs-3'>$queue</div>\n";
        echo "<div class='col-xs-3'>"._dgettext('queuelogin','Penalty').":</div>\n";
        echo "<div class='col-xs-2'><input type='text' value='1' class='item_Penalty form-control'></div>\n";
        echo "<div class='col-xs-3'><button class='item_add btn btn-default'>".__('Add')." <span class='fa fa-plus'></span> </button></div>\n";
        echo "</div>\n";
        echo "<br/>";
    }
    echo "</div>\n";
    echo "</div>\n";

    echo "<div class='col-xs-6 col-xs-offset-1 well'>\n";
    echo "<h3>"._dgettext('queuelogin','Configured Queues')."</h3>\n";
    //echo "<hr>\n";
    echo "<div style='clear:both;'></div>\n";
    echo "<div style='background-color: #eee;'>\n";
    echo "<div class='simpleCart_items'>\n";
    echo "</div>\n";
    echo "<div style='clear:both;'></div>\n";
    echo "</div>\n";

    echo "<br/>\n";
    
    echo "</div>\n";
    echo "</div>\n";
    echo "<hr/>\n";
    echo "<div class='pull-right'>\n";
    echo "<a class='btn btn-warning simpleCart_xcheckout' onclick='window.location = window.location.pathname + window.location.hash;'> ".__('Cancel')."</a>\n";
    echo "&nbsp;\n";
    echo "<button class='btn btn-primary simpleCart_checkout'>".__('Submit Changes')."</button>\n";
    echo "&nbsp;\n";
    echo "</div>\n";
    echo "</div>\n";

}

function final_javascript_code() {
    if(isset($_REQUEST['profile'])) { $profile=$_REQUEST['profile']; } else { $profile=''; }
    global $queues, $_REQUEST;
    $return="<script src='plugins/queuelogin/menu/simplecart.jsjs'></script>\n";
    $return .="<script>\n";

 
    $return .= "
      simpleCart({
       cartColumns: [
            { attr: 'name' , label: '"._dgettext('queuelogin','Queue')."' } ,
            { attr: 'penalty' , label: '"._dgettext('queuelogin','Penalty')."' } ,
            { view: 'remove' , text: \"<button class='btn btn-default'>".__('Delete')." <span class='fa fa-remove'></span></button>\" , label: false }
        ],
        checkout: { 
            type: 'SendForm' , 
            url: 'plugins/queuelogin/menu/configqueuelogin.php' ,
    
            // http method for form, 'POST' or 'GET', default is 'POST'
            method: 'POST' , 
    
            // url to return to on successful checkout, default is null
            success: 'plugins/queuelogin/menu/configqueuelogin.php?submit=ok' , 
    
            // url to return to on cancelled checkout, default is null
            cancel: 'plugins/queuelogin/menu/configqueuelogin.php?submit=error' ,
    
            // an option list of extra name/value pairs that can
            // be sent along with the checkout data

            extra_data: {
              profilename: \"".$profile."\",
              queueprefix: document.getElementById('prefijoqueue').value,
              popupurl_ringing: document.getElementById('popupurl_ringing').value,
              popupurl_connect: document.getElementById('popupurl_connect').value
            }
 
            //extra_data: {
            //  profilename: \"".$profile."\",
            //  prefix: document.getElementById('prefijo').value,
            //  queueprefix: document.getElementById('prefijoqueue').value,
            //  popup: document.getElementById('popupurl').value
            //}
        } 
    
      });
    ";

    
    // esta es para un edit
    if(isset($_REQUEST['profile'])) {
        $return .= "simpleCart.empty();\n";
        $return .= print_queue_penalties_js(isset($queues[$_REQUEST['profile']])?$queues[$_REQUEST['profile']]:'');
    } else {
       $return .= " // no tiene request profile\n";
    }

    // esta es para luego de un save
    if(isset($_REQUEST['profilename'])) {
        $return .= print_queue_penalties_js(isset($queues[$_REQUEST['profilename']])?$queues[$_REQUEST['profilename']]:'');
    }
    $return.="\n\n";
    $return .= "function  agregar() {
        alertify.prompt('"._dgettext('queuelogin','Enter a name')."', '', function (e, str) {
            // str is the input text
            if (e) {
                window.location.href='plugins/queuelogin/menu/configqueuelogin.php?profile='+str+'&action=insert';
            } else {
                // user clicked cancel
            }
        }).set({
        labels: { ok: lang['ok'], cancel: lang['cancel'] },
        title: '',
        type: 'text',
        closable: false
     });

        };\n";

    $return .= "simpleCart.bind( 'beforeCheckout' , function( data ){  \n";
    //$return .= "data.prefix = document.getElementById('prefijo').value;\n";
    $return .= "data.queueprefix = document.getElementById('prefijoqueue').value;\n";
    $return .= "data.popupurl_ringing = document.getElementById('popupurl_ringing').value;\n";
    $return .= "data.popupurl_connect = document.getElementById('popupurl_connect').value;\n";
    $return .= "});\n";


    $return .= "function confirmDelete(profile) {

     alertify.confirm('','".__('Are you sure?')."', function(e) {
             $('#'+profile).submit();
         },
         function() {
         }
     ).set({
        labels: {
            ok: '".__('Accept')."',
            cancel: '".__('Cancel')."'
        },
        closable: false
     });

     };
     ";

    $return .="</script>";
    return $return;
}

?>

</div>
</div>
</div>
<?php include("footerbs.php"); ?>
